/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.os.hardware.cpu;

import com.jn.langx.util.Emptys;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.os.hardware.cpu.GetCpuIdStreamHandler;
import java.io.IOException;
import java.util.List;

class LinuxGetCpuIdStreamHandler
extends GetCpuIdStreamHandler {
    LinuxGetCpuIdStreamHandler() {
    }

    @Override
    public void start() throws IOException {
        this.outputContent.reset();
        if (this.subProcessOutputStream != null) {
            List<String> lines = IOs.readLines(this.subProcessOutputStream);
            String cpuId = Collects.findFirst(lines, new Predicate<String>(){

                @Override
                public boolean test(String line) {
                    return Strings.isNotBlank(line);
                }
            });
            if (Strings.startsWith(cpuId, "ID:")) {
                cpuId = cpuId.substring("ID:".length());
            }
            if (Emptys.isNotEmpty(cpuId)) {
                this.outputContent.set(cpuId.trim());
            }
        }
    }

    @Override
    public String getCpuId() {
        return (String)this.outputContent.get();
    }
}

