/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.graph;

import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.collection.graph.Vertex;

public class Edge<T> {
    private Vertex<T> from;
    private Vertex<T> to;
    private String label;
    private int weight;

    public Edge(Vertex<T> from, Vertex<T> to) {
        this(from, to, 0);
    }

    public Edge(Vertex<T> from, Vertex<T> to, String label) {
        this(from, to, label, 0);
    }

    public Edge(Vertex<T> from, Vertex<T> to, int weight) {
        this(from, to, null, 0);
    }

    public Edge(Vertex<T> from, Vertex<T> to, String label, int weight) {
        this.from = from;
        this.to = to;
        this.weight = weight;
        this.setLabel(label);
    }

    public Vertex<T> getTo() {
        return this.to;
    }

    public Vertex<T> getFrom() {
        return this.from;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public String toString() {
        return StringTemplates.formatWithPlaceholder("from: {}, to: {}, label: {}, weight:{}", this.from.getName(), this.to.getName(), this.label, this.weight);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }
}

