/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.PrimitiveArrays;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.reflect.type.Primitives;
import com.jn.langx.util.struct.Holder;
import java.lang.reflect.Array;
import java.util.Arrays;

public class Arrs
extends PrimitiveArrays {
    public static int getLength(Object object) {
        if (Arrs.isArray(object)) {
            return Array.getLength(object);
        }
        return -1;
    }

    public static boolean isArray(@Nullable Object o) {
        return Emptys.isNotNull(o) && o.getClass().isArray();
    }

    public static <E> E[] wrapAsArray(@Nullable E o) {
        if (Emptys.isNull(o)) {
            return new Object[0];
        }
        ?[] array = Arrs.createArray(o.getClass(), 1);
        Arrs.initArray(array, o);
        return array;
    }

    public static <E> E[] createArray(@Nullable Class<E> componentType, int length) {
        Preconditions.checkTrue(length >= 0);
        if (componentType == null) {
            return (Object[])Array.newInstance(Object.class, length);
        }
        if (Primitives.isPrimitive(componentType)) {
            componentType = Primitives.wrap(componentType);
        }
        return (Object[])Array.newInstance(componentType, length);
    }

    public static <E> E[] createArray(@Nullable Class<E> componentType, int length, @Nullable E initValue) {
        E[] array = Arrs.createArray(componentType, length);
        Arrs.initArray(array, initValue);
        return array;
    }

    public static <E> E[] createArray(@Nullable Class<E> componentType, int length, @NonNull Supplier<Integer, E> initSupplier) {
        E[] array = Arrs.createArray(componentType, length);
        Arrs.initArray(array, initSupplier);
        return array;
    }

    public static <E> void initArray(@NonNull E[] array, final @Nullable E initValue) {
        Preconditions.checkNotNull(array);
        Arrs.initArray(array, new Supplier<Integer, E>(){

            @Override
            public E get(Integer index) {
                return initValue;
            }
        });
    }

    public static <E> void initArray(@NonNull E[] array, @NonNull Supplier<Integer, E> initSupplier) {
        Preconditions.checkNotNull(initSupplier);
        for (int i = 0; i < array.length; ++i) {
            array[i] = initSupplier.get(i);
        }
    }

    public static Integer[] range(int end) {
        return Arrs.range(0, end);
    }

    public static Integer[] range(int start, int end) {
        return Arrs.range(start, end, 1);
    }

    public static Integer[] range(final int start, int end, final int step) {
        Preconditions.checkTrue(start >= 0);
        Preconditions.checkTrue(end >= start);
        Preconditions.checkTrue(step >= 1);
        int length = (end - 1 - start) / step + 1;
        Preconditions.checkTrue(length >= 0);
        return Arrs.createArray(Integer.class, length, new Supplier<Integer, Integer>(){

            @Override
            public Integer get(Integer index) {
                return start + step * index;
            }
        });
    }

    public static boolean deepEquals(Object[] a1, Object[] a2) {
        return Arrays.deepEquals(a1, a2);
    }

    public static boolean deepEquals(Object e1, Object e2) {
        if (e1 == e2) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        boolean eq = e1 instanceof Object[] && e2 instanceof Object[] ? Arrays.deepEquals((Object[])e1, (Object[])e2) : (e1 instanceof byte[] && e2 instanceof byte[] ? PrimitiveArrays.equals((byte[])e1, (byte[])e2) : (e1 instanceof short[] && e2 instanceof short[] ? PrimitiveArrays.equals((short[])e1, (short[])e2) : (e1 instanceof int[] && e2 instanceof int[] ? PrimitiveArrays.equals((int[])e1, (int[])e2) : (e1 instanceof long[] && e2 instanceof long[] ? PrimitiveArrays.equals((long[])e1, (long[])e2) : (e1 instanceof char[] && e2 instanceof char[] ? PrimitiveArrays.equals((char[])e1, (char[])e2) : (e1 instanceof float[] && e2 instanceof float[] ? PrimitiveArrays.equals((float[])e1, (float[])e2) : (e1 instanceof double[] && e2 instanceof double[] ? PrimitiveArrays.equals((double[])e1, (double[])e2) : (e1 instanceof boolean[] && e2 instanceof boolean[] ? PrimitiveArrays.equals((boolean[])e1, (boolean[])e2) : e1.equals(e2)))))))));
        return eq;
    }

    public static <E> void swap(@NonNull E[] arr, int i, int j) {
        E tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static int toPositiveIndex(int length, int index) {
        Preconditions.checkTrue(Arrs.isValidIndex(length, index), "index " + index + " is invalid");
        if (Arrs.isNegativeIndex(length, index)) {
            return Arrs.reverseIndex(length, index, true);
        }
        return index;
    }

    public static int[] toPositiveIndexes(int length, int fromIndex, int toIndex) {
        if ((fromIndex = Arrs.toPositiveIndex(length, fromIndex)) > (toIndex = Arrs.toPositiveIndex(length, toIndex))) {
            int t = fromIndex;
            fromIndex = toIndex;
            toIndex = t;
        }
        int[] arr = new int[]{fromIndex, toIndex};
        return arr;
    }

    public static int reverseIndex(int length, int index) {
        return Arrs.reverseIndex(length, index, false);
    }

    public static int reverseIndex(int length, int index, boolean positiveNegativeInterChangeMode) {
        if (positiveNegativeInterChangeMode) {
            Preconditions.checkTrue(Arrs.isValidIndex(length, index), "index " + index + " is invalid");
            if (Arrs.isPositiveIndex(length, index)) {
                return index - length;
            }
            return length + index;
        }
        Preconditions.checkTrue(Arrs.isPositiveIndex(length, index), "index " + index + " is invalid");
        return length - 1 - index;
    }

    public static boolean isValidIndex(int length, int index) {
        return Arrs.isNegativeIndex(length, index) || Arrs.isPositiveIndex(length, index);
    }

    public static boolean isPositiveIndex(int length, int index) {
        Preconditions.checkTrue(length > 0, "length " + length + " is invalid");
        int max = length - 1;
        int min = 0;
        return index >= min && index <= max;
    }

    public static boolean isNegativeIndex(int length, int index) {
        Preconditions.checkTrue(length > 0, "length " + length + " is invalid");
        int max = -1;
        int min = -length;
        return index >= min && index <= max;
    }

    public static boolean contains(Object[] array, Object objectToFind) {
        return Arrs.indexOf(array, objectToFind) != -1;
    }

    public static <T> int indexOf(T[] array, Object objectToFind) {
        return Arrs.indexOf(array, objectToFind, 0);
    }

    public static int indexOf(Object[] array, Object objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (objectToFind == null) {
            for (int i = startIndex; i < array.length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = startIndex; i < array.length; ++i) {
                if (!objectToFind.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <E> E[] copy(E ... objs) {
        if (objs == null) {
            return null;
        }
        Class<?> componentType = objs.getClass().getComponentType();
        ?[] newArray = Arrs.createArray(componentType, objs.length);
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = objs[i];
        }
        return newArray;
    }

    public static <E> boolean isMixedArray(E[] objs) {
        final Holder elementType = new Holder();
        boolean isMixed = Collects.anyMatch(new Predicate<Object>(){

            @Override
            public boolean test(Object element) {
                if (element != null) {
                    if (elementType.isNull()) {
                        elementType.set(element.getClass());
                    } else {
                        return elementType.get() != element.getClass();
                    }
                }
                return false;
            }
        }, objs);
        objs.getClass().getComponentType();
        return isMixed;
    }
}

