/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.util.Emptys;
import com.jn.langx.util.Numbers;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Radixs;
import com.jn.langx.util.collection.Arrs;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.comparator.ComparableComparator;
import com.jn.langx.util.function.Consumer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class Maths {
    static final long FLOOR_SQRT_MAX_LONG = 3037000499L;
    private static final int DEFAULT_DIV_SCALE = 10;

    public static int max(int ... array) {
        Preconditions.checkTrue(array.length > 0);
        return (Integer)Collects.max(array, new ComparableComparator());
    }

    public static float maxFloat(float ... array) {
        Preconditions.checkTrue(array.length > 0);
        return ((Float)Collects.max(array, new ComparableComparator())).floatValue();
    }

    public static long maxLong(long ... array) {
        Preconditions.checkTrue(array.length > 0);
        return (Long)Collects.max(array, new ComparableComparator());
    }

    public static double maxDouble(double ... array) {
        Preconditions.checkTrue(array.length > 0);
        return (Double)Collects.max(array, new ComparableComparator());
    }

    public static int min(int ... array) {
        Preconditions.checkTrue(array.length > 0);
        return (Integer)Collects.min(array, new ComparableComparator());
    }

    public static float minFloat(float ... array) {
        Preconditions.checkTrue(array.length > 0);
        return ((Float)Collects.min(array, new ComparableComparator())).floatValue();
    }

    public static long minLong(long ... array) {
        Preconditions.checkTrue(array.length > 0);
        return (Long)Collects.min(array, new ComparableComparator());
    }

    public static double minDouble(double ... array) {
        Preconditions.checkTrue(array.length > 0);
        return (Double)Collects.min(array, new ComparableComparator());
    }

    public static boolean isOutOfBounds(int index, int length, int capacity) {
        return (index | length | index + length | capacity - (index + length)) < 0;
    }

    public static int abs(int value) {
        return value & Integer.MAX_VALUE;
    }

    public static int avg(int ... values) {
        Preconditions.checkNotNull(values);
        Preconditions.checkArgument(values.length >= 1);
        return Maths.sum(values) / values.length;
    }

    public static float avgFloat(float ... values) {
        Preconditions.checkNotNull(values);
        Preconditions.checkArgument(values.length >= 1);
        return Maths.sumFloat(values) / (float)values.length;
    }

    public static long avgLong(long ... values) {
        Preconditions.checkNotNull(values);
        Preconditions.checkArgument(values.length >= 1);
        return Maths.sumLong(values) / (long)values.length;
    }

    public static double avgDouble(double ... values) {
        Preconditions.checkNotNull(values);
        Preconditions.checkArgument(values.length >= 1);
        return Maths.sumDouble(values) / (double)values.length;
    }

    public static int sum(int ... values) {
        return Pipeline.of((Object)values).sum().intValue();
    }

    public static float sumFloat(float ... values) {
        return Pipeline.of((Object)values).sum().floatValue();
    }

    public static long sumLong(long ... values) {
        return Pipeline.of((Object)values).sum().longValue();
    }

    public static double sumDouble(double ... values) {
        return Pipeline.of((Object)values).sum();
    }

    public static Double formatPrecision(double value, int precision) {
        return Maths.formatPrecision(value, precision, RoundingMode.HALF_UP);
    }

    public static String formatPrecisionAsString(double value, int precision) {
        return Maths.formatPrecisionAsString(value, precision, RoundingMode.HALF_UP);
    }

    public static Double formatPrecision(double value, int precision, RoundingMode roundingMode) {
        String result = Maths.formatPrecisionAsString(value, precision, roundingMode);
        return Double.parseDouble(result);
    }

    public static String formatPrecisionAsString(double value, int precision, RoundingMode roundingMode) {
        Preconditions.checkArgument(precision >= 0);
        final StringBuilder pattern = precision > 0 ? new StringBuilder("#.") : new StringBuilder();
        Collects.forEach(Arrs.range(precision), new Consumer<Integer>(){

            @Override
            public void accept(Integer integer) {
                pattern.append("0");
            }
        });
        DecimalFormat nf = new DecimalFormat(pattern.toString());
        ((NumberFormat)nf).setMaximumFractionDigits(precision);
        ((NumberFormat)nf).setRoundingMode(roundingMode == null ? RoundingMode.HALF_UP : roundingMode);
        String string = nf.format(value);
        return string;
    }

    public static boolean isPower2(int value) {
        return value >= 1 && (value & value - 1) == 0;
    }

    public static int pow2Int(int pow) {
        return Numbers.toInt(Math.pow(2.0, pow));
    }

    public static int pow2Long(int pow) {
        return Numbers.toInt(Math.pow(2.0, pow));
    }

    public static long saturatedAdd(long a, long b) {
        long naiveSum;
        if ((a ^ b) < 0L | (a ^ (naiveSum = a + b)) >= 0L) {
            return naiveSum;
        }
        return Long.MAX_VALUE + (naiveSum >>> 63 ^ 1L);
    }

    public static long saturatedSubtract(long a, long b) {
        long naiveDifference;
        if ((a ^ b) >= 0L | (a ^ (naiveDifference = a - b)) >= 0L) {
            return naiveDifference;
        }
        return Long.MAX_VALUE + (naiveDifference >>> 63 ^ 1L);
    }

    public static long saturatedMultiply(long a, long b) {
        int leadingZeros = Long.numberOfLeadingZeros(a) + Long.numberOfLeadingZeros(a ^ 0xFFFFFFFFFFFFFFFFL) + Long.numberOfLeadingZeros(b) + Long.numberOfLeadingZeros(b ^ 0xFFFFFFFFFFFFFFFFL);
        if (leadingZeros > 65) {
            return a * b;
        }
        long limit = Long.MAX_VALUE + ((a ^ b) >>> 63);
        if (leadingZeros < 64 | a < 0L & b == Long.MIN_VALUE) {
            return limit;
        }
        long result = a * b;
        if (a == 0L || result / a == b) {
            return result;
        }
        return limit;
    }

    public static long saturatedPow(long b, int k) {
        if (k < 0) {
            throw new IllegalArgumentException(" Argument k must be >= 0");
        }
        if (b >= -2L & b <= 2L) {
            switch ((int)b) {
                case 0: {
                    return k == 0 ? 1L : 0L;
                }
                case 1: {
                    return 1L;
                }
                case -1: {
                    return (k & 1) == 0 ? 1L : -1L;
                }
                case 2: {
                    if (k >= 63) {
                        return Long.MAX_VALUE;
                    }
                    return 1L << k;
                }
                case -2: {
                    if (k >= 64) {
                        return Long.MAX_VALUE + (long)(k & 1);
                    }
                    return (k & 1) == 0 ? 1L << k : -1L << k;
                }
            }
            throw new AssertionError();
        }
        long accum = 1L;
        long limit = Long.MAX_VALUE + (b >>> 63 & (long)(k & 1));
        while (true) {
            switch (k) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return Maths.saturatedMultiply(accum, b);
                }
            }
            if ((k & 1) != 0) {
                accum = Maths.saturatedMultiply(accum, b);
            }
            if ((k >>= 1) <= 0) continue;
            if (-3037000499L > b | b > 3037000499L) {
                return limit;
            }
            b *= b;
        }
    }

    public static int clz32(int a) {
        return Maths.clzN(a, 32);
    }

    public static int clzN(int a, int n) {
        char c;
        String binaryText = Radixs.toBinary(a);
        int clz = 0;
        if (binaryText.length() < n) {
            clz = n - binaryText.length();
            clz = Maths.max(0, clz);
        }
        char[] cs = binaryText.toCharArray();
        int delta = 0;
        for (int i = 0; i < cs.length && (c = cs[i]) == '0'; ++i) {
            delta = i + 1;
        }
        return clz + delta;
    }

    public static double mul(float v1, float v2) {
        return Maths.mul(Float.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double mul(float v1, double v2) {
        return Maths.mul(Float.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double mul(double v1, float v2) {
        return Maths.mul(Double.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double mul(double v1, double v2) {
        return Maths.mul(Double.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double mul(Double v1, Double v2) {
        return Maths.mul((Number)v1, (Number)v2).doubleValue();
    }

    public static BigDecimal mul(Number v1, Number v2) {
        return Maths.mul(new Number[]{v1, v2});
    }

    public static BigDecimal mul(Number ... values) {
        if (Objs.isEmpty(values) || Emptys.isAnyEmpty(values)) {
            return BigDecimal.ZERO;
        }
        Number value = values[0];
        BigDecimal result = new BigDecimal(value.toString());
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            result = result.multiply(new BigDecimal(value.toString()));
        }
        return result;
    }

    public static BigDecimal mul(String v1, String v2) {
        return Maths.mul((Number)new BigDecimal(v1), (Number)new BigDecimal(v2));
    }

    public static BigDecimal mul(String ... values) {
        if (Objs.isEmpty(values) || Emptys.isAnyEmpty(values)) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = new BigDecimal(values[0]);
        for (int i = 1; i < values.length; ++i) {
            result = result.multiply(new BigDecimal(values[i]));
        }
        return result;
    }

    public static BigDecimal mul(BigDecimal ... values) {
        if (Objs.isEmpty(values) || Emptys.isAnyEmpty(values)) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = values[0];
        for (int i = 1; i < values.length; ++i) {
            result = result.multiply(values[i]);
        }
        return result;
    }

    public static double div(float v1, float v2) {
        return Maths.div(v1, v2, 10);
    }

    public static double div(float v1, double v2) {
        return Maths.div(v1, v2, 10);
    }

    public static double div(double v1, float v2) {
        return Maths.div(v1, v2, 10);
    }

    public static double div(double v1, double v2) {
        return Maths.div(v1, v2, 10);
    }

    public static double div(Double v1, Double v2) {
        return Maths.div(v1, v2, 10);
    }

    public static BigDecimal div(Number v1, Number v2) {
        return Maths.div(v1, v2, 10);
    }

    public static BigDecimal div(String v1, String v2) {
        return Maths.div(v1, v2, 10);
    }

    public static double div(float v1, float v2, int scale) {
        return Maths.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(float v1, double v2, int scale) {
        return Maths.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(double v1, float v2, int scale) {
        return Maths.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(double v1, double v2, int scale) {
        return Maths.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(Double v1, Double v2, int scale) {
        return Maths.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal div(Number v1, Number v2, int scale) {
        return Maths.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal div(String v1, String v2, int scale) {
        return Maths.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(float v1, float v2, int scale, RoundingMode roundingMode) {
        return Maths.div(Float.toString(v1), Float.toString(v2), scale, roundingMode).doubleValue();
    }

    public static double div(float v1, double v2, int scale, RoundingMode roundingMode) {
        return Maths.div(Float.toString(v1), Double.toString(v2), scale, roundingMode).doubleValue();
    }

    public static double div(double v1, float v2, int scale, RoundingMode roundingMode) {
        return Maths.div(Double.toString(v1), Float.toString(v2), scale, roundingMode).doubleValue();
    }

    public static double div(double v1, double v2, int scale, RoundingMode roundingMode) {
        return Maths.div(Double.toString(v1), Double.toString(v2), scale, roundingMode).doubleValue();
    }

    public static double div(Double v1, Double v2, int scale, RoundingMode roundingMode) {
        return Maths.div((Number)v1, (Number)v2, scale, roundingMode).doubleValue();
    }

    public static BigDecimal div(Number v1, Number v2, int scale, RoundingMode roundingMode) {
        if (v1 instanceof BigDecimal && v2 instanceof BigDecimal) {
            return Maths.div((BigDecimal)v1, (BigDecimal)v2, scale, roundingMode);
        }
        return Maths.div(Objs.toStringOrNull(v1), Objs.toStringOrNull(v2), scale, roundingMode);
    }

    public static BigDecimal div(String v1, String v2, int scale, RoundingMode roundingMode) {
        return Maths.div(Numbers.createBigDecimal(v1), Numbers.createBigDecimal(v2), scale, roundingMode);
    }

    public static BigDecimal div(BigDecimal v1, BigDecimal v2, int scale, RoundingMode roundingMode) {
        Preconditions.checkNotNull(v2, "Divisor must be not null !");
        if (null == v1) {
            return BigDecimal.ZERO;
        }
        if (scale < 0) {
            scale = -scale;
        }
        return v1.divide(v2, scale, roundingMode);
    }

    public static final class HashMaths {
        private static final int PRESELECTED_PRIME = 1299827;

        private HashMaths() {
        }

        public static int roundToPowerOfTwo(int value) {
            Preconditions.checkArgument(value >= 0, "min value is 0");
            Preconditions.checkArgument(value <= 0x40000000, "min value is {}", 0x40000000);
            return value <= 1 ? value : Integer.highestOneBit(value - 1) << 1;
        }

        public static int multiHashOrdered(int accumulatedHash, int prime, int nextHash) {
            return HashMaths.multiplyWrap(accumulatedHash, prime) + nextHash;
        }

        public static int multiHashUnordered(int accumulatedHash, int prime, int nextHash) {
            return HashMaths.multiplyWrap(nextHash, prime) + accumulatedHash;
        }

        public static int multiHashOrdered(int accumulatedHash, int nextHash) {
            return HashMaths.multiHashOrdered(accumulatedHash, 1299827, nextHash);
        }

        public static int multiHashUnordered(int accumulatedHash, int nextHash) {
            return HashMaths.multiHashUnordered(accumulatedHash, 1299827, nextHash);
        }

        public static int multiplyWrap(int a, int b) {
            long r1 = (long)a * (long)b;
            return (int)r1 ^ (int)(r1 >>> 32);
        }
    }
}

