/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.util.EmptyEvalutible;
import com.jn.langx.util.Numbers;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Arrs;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.collection.buffer.Buffer;
import com.jn.langx.util.function.Functions;
import com.jn.langx.util.struct.Holder;
import com.jn.langx.util.struct.Reference;
import java.util.Collection;
import java.util.Map;

public class Emptys {
    public static final int[] EMPTY_INTS = new int[0];
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final char[] EMPTY_CHARS = new char[0];
    public static final Object[] EMPTY_OBJECTS = new Object[0];
    public static final Class<?>[] EMPTY_CLASSES = new Class[0];
    public static final String[] EMPTY_STRINGS = new String[0];
    public static final String EMPTY_STRING = "";

    private Emptys() {
    }

    public static boolean isAnyEmpty(Object ... args) {
        return Collects.anyMatch(Functions.<Object>emptyPredicate(), args);
    }

    public static boolean isNoneEmpty(Object ... args) {
        return Collects.noneMatch(Functions.emptyPredicate(), args);
    }

    public static boolean isAllEmpty(Object ... args) {
        return Collects.allMatch(Functions.emptyPredicate(), args);
    }

    public static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        if (object.getClass().isArray()) {
            return Arrs.getLength(object) <= 0;
        }
        if (object instanceof String) {
            return Strings.isEmpty((String)object);
        }
        if (object instanceof CharSequence) {
            CharSequence cs = (CharSequence)object;
            return cs.length() == 0;
        }
        if (object instanceof Number) {
            return Numbers.isZero((Number)object);
        }
        if (object instanceof java.nio.Buffer) {
            java.nio.Buffer buff = (java.nio.Buffer)object;
            return buff.hasRemaining();
        }
        if (object.getClass().isEnum()) {
            return false;
        }
        if (object instanceof EmptyEvalutible) {
            return ((EmptyEvalutible)object).isEmpty();
        }
        if (object instanceof Holder) {
            return ((Holder)object).isEmpty();
        }
        if (object instanceof Reference) {
            return ((Reference)object).isNull();
        }
        if (object instanceof Buffer) {
            return ((Buffer)object).hasRemaining();
        }
        return false;
    }

    public static boolean isNotEmpty(Object o) {
        return !Emptys.isEmpty(o);
    }

    public static boolean isNull(Object o) {
        return o == null;
    }

    public static boolean isNotNull(Object o) {
        return o != null;
    }

    public static <T> int getLength(T object) {
        if (Emptys.isNull(object)) {
            return 0;
        }
        if (object instanceof String) {
            return ((String)object).length();
        }
        if (object instanceof CharSequence) {
            CharSequence cs = (CharSequence)object;
            return cs.length();
        }
        if (object instanceof Number) {
            return 1;
        }
        if (object instanceof java.nio.Buffer) {
            java.nio.Buffer buff = (java.nio.Buffer)object;
            return buff.remaining();
        }
        if (object instanceof Collection) {
            return ((Collection)object).size();
        }
        if (object instanceof Map) {
            return ((Map)object).size();
        }
        if (object.getClass().isArray()) {
            return Arrs.getLength(object);
        }
        if (object.getClass().isEnum()) {
            return 1;
        }
        if (object instanceof Holder) {
            Holder holder = (Holder)object;
            return Emptys.getLength(holder.get());
        }
        return Pipeline.of(object).asList().size();
    }
}

