/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.grok.pattern;

import com.jn.langx.annotation.NullableIf;
import com.jn.langx.configuration.BaseConfigurationRepository;
import com.jn.langx.configuration.ConfigurationEventType;
import com.jn.langx.text.grok.pattern.PatternDefinition;
import com.jn.langx.text.grok.pattern.PatternDefinitionLoader;
import com.jn.langx.text.grok.pattern.PatternDefinitionRepository;
import com.jn.langx.text.grok.pattern.PatternDefinitionWriter;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.concurrent.CommonThreadFactory;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.timing.timer.HashedWheelTimer;
import com.jn.langx.util.timing.timer.Timeout;
import com.jn.langx.util.timing.timer.Timer;
import com.jn.langx.util.timing.timer.TimerTask;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class SimplePatternDefinitionRepository
extends BaseConfigurationRepository<PatternDefinition, PatternDefinitionLoader, PatternDefinitionWriter>
implements PatternDefinitionRepository {
    private Map<String, PatternDefinition> definitions = new ConcurrentHashMap<String, PatternDefinition>();
    protected int reloadIntervalInSeconds = -1;
    @NullableIf(value="reloadIntervalInSeconds > 0")
    private Timer timer;

    public void setReloadIntervalInSeconds(int reloadIntervalInSeconds) {
        this.reloadIntervalInSeconds = reloadIntervalInSeconds;
    }

    @Override
    protected void doStart() {
        if (!this.inited) {
            this.init();
        }
        final Logger logger = Loggers.getLogger(this.getClass());
        logger.info("Startup configuration repository: {}", (Object)this.getName());
        if (this.reloadIntervalInSeconds > 0) {
            try {
                this.reload();
            }
            catch (Throwable ex) {
                logger.warn(ex.getMessage(), ex);
            }
            if (this.timer == null) {
                logger.warn("The timer is not specified for the repository ({}) , will use a simple timer", (Object)this.getName());
                this.timer = new HashedWheelTimer(new CommonThreadFactory("Configuration", true), 50L, TimeUnit.MILLISECONDS);
            }
            this.timer.newTimeout(new TimerTask(){

                @Override
                public void run(Timeout timeout) throws Exception {
                    try {
                        SimplePatternDefinitionRepository.this.reload();
                    }
                    catch (Throwable ex) {
                        logger.error(ex.getMessage(), ex);
                    }
                    finally {
                        if (SimplePatternDefinitionRepository.this.isRunning()) {
                            SimplePatternDefinitionRepository.this.timer.newTimeout(this, (long)SimplePatternDefinitionRepository.this.reloadIntervalInSeconds, TimeUnit.SECONDS);
                        }
                    }
                }
            }, (long)this.reloadIntervalInSeconds, TimeUnit.SECONDS);
        } else {
            this.reload();
        }
    }

    @Override
    protected void doStop() {
        Logger logger = Loggers.getLogger(this.getClass());
        logger.info("Shutdown configuration repository: {}", (Object)this.getName());
        this.definitions.clear();
    }

    @Override
    public PatternDefinition getById(String id) {
        return this.definitions.get(id);
    }

    @Override
    public void removeById(String id, boolean sync) {
        PatternDefinition configuration = this.definitions.get(id);
        if (configuration != null) {
            this.logMutation(ConfigurationEventType.REMOVE, configuration);
            if (sync && this.writer != null && ((PatternDefinitionWriter)this.writer).isSupportsRemove()) {
                ((PatternDefinitionWriter)this.writer).remove(id);
            }
            this.definitions.remove(id);
            if (this.eventPublisher != null && this.eventFactory != null) {
                this.eventPublisher.publish(this.eventFactory.createEvent(ConfigurationEventType.ADD, configuration));
            }
        }
    }

    @Override
    public PatternDefinition add(PatternDefinition configuration, boolean sync) {
        if (this.isRunning()) {
            this.logMutation(ConfigurationEventType.ADD, configuration);
            if (sync && this.writer != null && ((PatternDefinitionWriter)this.writer).isSupportsWrite()) {
                ((PatternDefinitionWriter)this.writer).write(configuration);
            }
            this.definitions.put(configuration.getId(), configuration);
            if (this.eventPublisher != null && this.eventFactory != null) {
                this.eventPublisher.publish(this.eventFactory.createEvent(ConfigurationEventType.ADD, configuration));
            }
        }
        return configuration;
    }

    @Override
    public void update(PatternDefinition configuration, boolean sync) {
        if (this.isRunning()) {
            this.logMutation(ConfigurationEventType.UPDATE, configuration);
            if (sync && this.writer != null && ((PatternDefinitionWriter)this.writer).isSupportsRewrite()) {
                ((PatternDefinitionWriter)this.writer).rewrite(configuration);
            }
            this.definitions.put(configuration.getId(), configuration);
            if (this.eventPublisher != null && this.eventFactory != null) {
                this.eventPublisher.publish(this.eventFactory.createEvent(ConfigurationEventType.UPDATE, configuration));
            }
        }
    }

    @Override
    protected void doInit() {
        Preconditions.checkNotNull(this.getName(), "Repository has no named");
        Logger logger = Loggers.getLogger(this.getClass());
        logger.info("Initial configuration repository: {}", (Object)this.getName());
    }

    @Override
    public Map<String, PatternDefinition> getAll() {
        return Collects.immutableMap(this.definitions);
    }
}

