/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.csv;

import com.jn.langx.text.csv.CsvFormat;
import com.jn.langx.text.csv.CsvLexer;
import com.jn.langx.text.csv.CsvRecord;
import com.jn.langx.text.csv.ExtendedBufferedReader;
import com.jn.langx.text.csv.Token;
import com.jn.langx.util.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;

public final class CsvParser
implements Iterable<CsvRecord>,
Closeable {
    private final CsvFormat format;
    private final Map<String, Integer> headerMap;
    private final List<String> headerNames;
    private final CsvLexer lexer;
    private final CSVRecordIterator csvRecordIterator;
    private final List<String> recordList = new ArrayList<String>();
    private long recordNumber;
    private final long characterOffset;
    private final Token reusableToken = new Token();

    public static CsvParser parse(File file, Charset charset, CsvFormat format) throws IOException {
        Preconditions.checkNotNull(file, "file");
        Preconditions.checkNotNull(format, "format");
        return new CsvParser(new InputStreamReader((InputStream)new FileInputStream(file), charset), format);
    }

    public static CsvParser parse(InputStream inputStream, Charset charset, CsvFormat format) throws IOException {
        Preconditions.checkNotNull(inputStream, "inputStream");
        Preconditions.checkNotNull(format, "format");
        return CsvParser.parse(new InputStreamReader(inputStream, charset), format);
    }

    public static CsvParser parse(Reader reader, CsvFormat format) throws IOException {
        return new CsvParser(reader, format);
    }

    public static CsvParser parse(String string, CsvFormat format) throws IOException {
        Preconditions.checkNotNull(string, "string");
        Preconditions.checkNotNull(format, "format");
        return new CsvParser(new StringReader(string), format);
    }

    public static CsvParser parse(URL url, Charset charset, CsvFormat format) throws IOException {
        Preconditions.checkNotNull(url, "url");
        Preconditions.checkNotNull(charset, "charset");
        Preconditions.checkNotNull(format, "format");
        return new CsvParser(new InputStreamReader(url.openStream(), charset), format);
    }

    public CsvParser(Reader reader, CsvFormat format) throws IOException {
        this(reader, format, 0L, 1L);
    }

    public CsvParser(Reader reader, CsvFormat format, long characterOffset, long recordNumber) throws IOException {
        Preconditions.checkNotNull(reader, "reader");
        Preconditions.checkNotNull(format, "format");
        this.format = format;
        this.lexer = new CsvLexer(format, new ExtendedBufferedReader(reader));
        this.csvRecordIterator = new CSVRecordIterator();
        Headers headers = this.createHeaders();
        this.headerMap = headers.headerMap;
        this.headerNames = headers.headerNames;
        this.characterOffset = characterOffset;
        this.recordNumber = recordNumber - 1L;
    }

    private void addRecordValue(boolean lastRecord) {
        String inputClean;
        String input = this.reusableToken.content.toString();
        String string = inputClean = this.format.getTrim() ? input.trim() : input;
        if (lastRecord && inputClean.isEmpty() && this.format.getTrailingDelimiter()) {
            return;
        }
        String nullString = this.format.getNullString();
        this.recordList.add(inputClean.equals(nullString) ? null : inputClean);
    }

    @Override
    public void close() throws IOException {
        if (this.lexer != null) {
            this.lexer.close();
        }
    }

    private Map<String, Integer> createEmptyHeaderMap() {
        return this.format.getIgnoreHeaderCase() ? new TreeMap(String.CASE_INSENSITIVE_ORDER) : new LinkedHashMap();
    }

    private Headers createHeaders() throws IOException {
        Map<String, Integer> hdrMap = null;
        List<String> headerNames = null;
        Object[] formatHeader = this.format.getHeader();
        if (formatHeader != null) {
            hdrMap = this.createEmptyHeaderMap();
            Object[] headerRecord = null;
            if (formatHeader.length == 0) {
                CsvRecord nextRecord = this.nextRecord();
                if (nextRecord != null) {
                    headerRecord = nextRecord.values();
                }
            } else {
                if (this.format.getSkipHeaderRecord()) {
                    this.nextRecord();
                }
                headerRecord = formatHeader;
            }
            if (headerRecord != null) {
                for (int i = 0; i < headerRecord.length; ++i) {
                    boolean emptyHeader;
                    String header = headerRecord[i];
                    boolean containsHeader = header == null ? false : hdrMap.containsKey(header);
                    boolean bl = emptyHeader = header == null || header.trim().isEmpty();
                    if (containsHeader) {
                        if (!emptyHeader && !this.format.getAllowDuplicateHeaderNames()) {
                            throw new IllegalArgumentException(String.format("The header contains a duplicate name: \"%s\" in %s. If this is valid then use CSVFormat.withAllowDuplicateHeaderNames().", header, Arrays.toString(headerRecord)));
                        }
                        if (emptyHeader && !this.format.getAllowMissingColumnNames()) {
                            throw new IllegalArgumentException("A header name is missing in " + Arrays.toString(headerRecord));
                        }
                    }
                    if (header == null) continue;
                    hdrMap.put(header, i);
                    if (headerNames == null) {
                        headerNames = new ArrayList<String>(headerRecord.length);
                    }
                    headerNames.add(header);
                }
            }
        }
        headerNames = headerNames == null ? Collections.emptyList() : Collections.unmodifiableList(headerNames);
        return new Headers(hdrMap, headerNames);
    }

    public long getCurrentLineNumber() {
        return this.lexer.getCurrentLineNumber();
    }

    public String getFirstEndOfLine() {
        return this.lexer.getFirstEol();
    }

    public Map<String, Integer> getHeaderMap() {
        if (this.headerMap == null) {
            return null;
        }
        Map<String, Integer> map = this.createEmptyHeaderMap();
        map.putAll(this.headerMap);
        return map;
    }

    Map<String, Integer> getHeaderMapRaw() {
        return this.headerMap;
    }

    public List<String> getHeaderNames() {
        return this.headerNames;
    }

    public long getRecordNumber() {
        return this.recordNumber;
    }

    public List<CsvRecord> getRecords() throws IOException {
        CsvRecord rec;
        ArrayList<CsvRecord> records = new ArrayList<CsvRecord>();
        while ((rec = this.nextRecord()) != null) {
            records.add(rec);
        }
        return records;
    }

    public boolean isClosed() {
        return this.lexer.isClosed();
    }

    @Override
    public Iterator<CsvRecord> iterator() {
        return this.csvRecordIterator;
    }

    CsvRecord nextRecord() throws IOException {
        CsvRecord result = null;
        this.recordList.clear();
        StringBuilder sb = null;
        long startCharPosition = this.lexer.getCharacterPosition() + this.characterOffset;
        block7: do {
            this.reusableToken.reset();
            this.lexer.nextToken(this.reusableToken);
            switch (this.reusableToken.type) {
                case TOKEN: {
                    this.addRecordValue(false);
                    break;
                }
                case EORECORD: {
                    this.addRecordValue(true);
                    break;
                }
                case EOF: {
                    if (!this.reusableToken.isReady) continue block7;
                    this.addRecordValue(true);
                    break;
                }
                case INVALID: {
                    throw new IOException("(line " + this.getCurrentLineNumber() + ") invalid parse sequence");
                }
                case COMMENT: {
                    if (sb == null) {
                        sb = new StringBuilder();
                    } else {
                        sb.append('\n');
                    }
                    sb.append((CharSequence)this.reusableToken.content);
                    this.reusableToken.type = Token.Type.TOKEN;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected Token type: " + (Object)((Object)this.reusableToken.type));
                }
            }
        } while (this.reusableToken.type == Token.Type.TOKEN);
        if (!this.recordList.isEmpty()) {
            ++this.recordNumber;
            String comment = sb == null ? null : sb.toString();
            result = new CsvRecord(this, this.recordList.toArray(new String[this.recordList.size()]), comment, this.recordNumber, startCharPosition);
        }
        return result;
    }

    private static final class Headers {
        final Map<String, Integer> headerMap;
        final List<String> headerNames;

        Headers(Map<String, Integer> headerMap, List<String> headerNames) {
            this.headerMap = headerMap;
            this.headerNames = headerNames;
        }
    }

    class CSVRecordIterator
    implements Iterator<CsvRecord> {
        private CsvRecord current;

        CSVRecordIterator() {
        }

        private CsvRecord getNextRecord() {
            try {
                return CsvParser.this.nextRecord();
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getClass().getSimpleName() + " reading next record: " + e.toString(), e);
            }
        }

        @Override
        public boolean hasNext() {
            if (CsvParser.this.isClosed()) {
                return false;
            }
            if (this.current == null) {
                this.current = this.getNextRecord();
            }
            return this.current != null;
        }

        @Override
        public CsvRecord next() {
            if (CsvParser.this.isClosed()) {
                throw new NoSuchElementException("CSVParser has been closed");
            }
            CsvRecord next = this.current;
            this.current = null;
            if (next == null && (next = this.getNextRecord()) == null) {
                throw new NoSuchElementException("No more CSV records available");
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

