/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.resource;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.io.resource.AbstractLocatableResource;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.io.file.Filenames;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class FileResource
extends AbstractLocatableResource<File> {
    private File file;
    public static final String PREFIX = "file:";
    public static final String FILE_URL_PATTERN = "file://";
    private String cleanedPath;

    public FileResource(@NonNull String path) {
        Preconditions.checkTrue(path.startsWith(PREFIX) && !path.startsWith(FILE_URL_PATTERN));
        this.setPath(path);
    }

    private void setPath(String path) {
        this.cleanedPath = path.substring(PREFIX.length());
        this.setLocation(PREFIX, this.cleanedPath);
        this.cleanedPath = Filenames.cleanPath(this.cleanedPath);
        this.file = new File(this.cleanedPath);
    }

    @Override
    public URL getUrl() {
        if (this.exists()) {
            try {
                return this.file.toURL();
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getAbsolutePath() {
        return this.exists() ? this.file.getAbsolutePath() : null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public boolean isReadable() {
        return this.exists() && this.file.canRead();
    }

    @Override
    public boolean exists() {
        return this.file != null && this.file.exists();
    }

    @Override
    public File getRealResource() {
        return this.file;
    }

    @Override
    public long contentLength() {
        return this.exists() ? this.file.length() : -1L;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileResource)) {
            return false;
        }
        FileResource o2 = (FileResource)obj;
        return this.cleanedPath.equals(o2.cleanedPath);
    }

    public int hashCode() {
        return this.cleanedPath.hashCode();
    }
}

