/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.resource;

import com.jn.langx.io.resource.DefaultResourceLoader;
import com.jn.langx.io.resource.FileResource;
import com.jn.langx.io.resource.ResourceLoader;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.io.file.FileFilter;
import com.jn.langx.util.io.file.filter.ExistsFileFilter;
import com.jn.langx.util.io.file.filter.IsDirectoryFileFilter;
import com.jn.langx.util.io.file.filter.ReadableFileFilter;
import java.io.File;
import java.util.List;

public class DirectoryBasedFileResourceLoader
implements ResourceLoader {
    private String directory;
    private ResourceLoader delegate;

    public DirectoryBasedFileResourceLoader(String directory) {
        this(directory, null);
    }

    public DirectoryBasedFileResourceLoader(String directory, ClassLoader classLoader) {
        Preconditions.checkNotNull(directory, "directory is null");
        Preconditions.checkTrue(new ExistsFileFilter().test(new File(directory)), StringTemplates.formatWithPlaceholder("directory {} is not exists", directory));
        Preconditions.checkTrue(new IsDirectoryFileFilter().test(new File(directory)), StringTemplates.formatWithPlaceholder("directory {} is not a directory", directory));
        Preconditions.checkTrue(new ReadableFileFilter().test(new File(directory)), StringTemplates.formatWithPlaceholder("directory {} is not readable", directory));
        this.directory = directory;
        this.delegate = new DefaultResourceLoader(classLoader);
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public FileResource loadResource(String filename) {
        return (FileResource)this.delegate.loadResource("file:" + this.directory + File.separator + filename);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.delegate.getClassLoader();
    }

    public List<File> listFiles() {
        File dir = new File(this.directory);
        return Pipeline.of(dir.listFiles()).map(new Function<File, File>(){

            @Override
            public File apply(File file) {
                return file.getAbsoluteFile();
            }
        }).asList();
    }

    public List<File> listFiles(FileFilter fileFilter) {
        File dir = new File(this.directory);
        return Pipeline.of(dir.listFiles(fileFilter)).map(new Function<File, File>(){

            @Override
            public File apply(File file) {
                return file.getAbsoluteFile();
            }
        }).asList();
    }
}

