/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.distributed.session.impl;

import com.jn.langx.Delegatable;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.cache.Cache;
import com.jn.langx.distributed.session.Session;
import com.jn.langx.distributed.session.SessionRepository;
import java.util.concurrent.TimeUnit;

public class CachedSessionRepository
implements SessionRepository,
Delegatable<SessionRepository> {
    @NonNull
    private Cache<String, Session> cache;
    @NonNull
    private SessionRepository delegate;

    @Override
    public SessionRepository getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(SessionRepository delegate) {
        this.delegate = delegate;
    }

    public Cache<String, Session> getCache() {
        return this.cache;
    }

    public void setCache(Cache<String, Session> cache) {
        this.cache = cache;
    }

    @Override
    public Session getById(String id) {
        Session session = this.cache.get(id);
        if (session == null) {
            session = this.delegate.getById(id);
        }
        return session;
    }

    @Override
    public void add(Session session) {
        this.cache.set(session.getId(), session, session.getMaxInactiveInterval(), TimeUnit.MILLISECONDS);
        this.delegate.add(session);
    }

    @Override
    public void update(Session session) {
        this.cache.set(session.getId(), session, session.getMaxInactiveInterval(), TimeUnit.MILLISECONDS);
        this.delegate.update(session);
    }

    @Override
    public void removeById(String id) {
        this.cache.remove(id);
        this.delegate.removeById(id);
    }
}

