/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.commandline;

import com.jn.langx.util.io.Charsets;
import com.jn.langx.util.logging.Loggers;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;

public abstract class LogOutputStream
extends OutputStream {
    private static final int INTIAL_SIZE = 132;
    private static final int CR = 13;
    private static final int LF = 10;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream(132);
    private boolean skip = false;
    private final int level;

    public LogOutputStream() {
        this(999);
    }

    public LogOutputStream(int level) {
        this.level = level;
    }

    @Override
    public void write(int cc) throws IOException {
        byte c = (byte)cc;
        if (c == 10 || c == 13) {
            if (!this.skip) {
                this.processBuffer();
            }
        } else {
            this.buffer.write(cc);
        }
        this.skip = c == 13;
    }

    @Override
    public void flush() {
        if (this.buffer.size() > 0) {
            this.processBuffer();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.buffer.size() > 0) {
            this.processBuffer();
        }
        super.close();
    }

    public int getMessageLevel() {
        return this.level;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int offset;
        int blockStartOffset = offset = off;
        int remaining = len;
        while (remaining > 0) {
            while (remaining > 0 && b[offset] != 10 && b[offset] != 13) {
                ++offset;
                --remaining;
            }
            int blockLength = offset - blockStartOffset;
            if (blockLength > 0) {
                this.buffer.write(b, blockStartOffset, blockLength);
            }
            while (remaining > 0 && (b[offset] == 10 || b[offset] == 13)) {
                this.write(b[offset]);
                ++offset;
                --remaining;
            }
            blockStartOffset = offset;
        }
    }

    protected void processBuffer() {
        try {
            this.processLine(this.buffer.toString(Charsets.UTF_8.name()));
            this.buffer.reset();
        }
        catch (Throwable ex) {
            Logger logger = Loggers.getLogger(this.getClass());
            logger.error(ex.getMessage(), ex);
        }
    }

    protected void processLine(String line) {
        this.processLine(line, this.level);
    }

    protected abstract void processLine(String var1, int var2);
}

