/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.codec.z85;

import com.jn.langx.codec.CodecException;
import com.jn.langx.codec.Decoder;
import com.jn.langx.codec.z85.Z85;

public class Z85Decoder
implements Decoder<String, byte[]> {
    @Override
    public byte[] decode(String string) throws CodecException {
        int remainder = string.length() % 5;
        int padding = 5 - (remainder == 0 ? 5 : remainder);
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int p = 0; p < padding; ++p) {
            stringBuilder.append(Z85.encodeTable[Z85.encodeTable.length - 1]);
        }
        string = stringBuilder.toString();
        int length = string.length();
        byte[] bytes = new byte[length * 4 / 5 - padding];
        long value = 0L;
        int index = 0;
        for (int i = 0; i < length; ++i) {
            int code = string.charAt(i) - 32;
            value = value * 85L + (long)Z85.decodeTable[code];
            if ((i + 1) % 5 != 0) continue;
            for (int divisor = 0x1000000; divisor >= 1; divisor /= 256) {
                if (index >= bytes.length) continue;
                bytes[index++] = (byte)(value / (long)divisor % 256L);
            }
            value = 0L;
        }
        return bytes;
    }
}

