/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.chain;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.chain.AbstractChain;
import com.jn.langx.chain.Handler;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.struct.counter.IntegerCounter;
import com.jn.langx.util.struct.counter.SimpleIntegerCounter;
import com.jn.langx.util.struct.counter.ThreadLocalIntegerCounter;
import java.util.List;

public class FilterChain<REQ, RESP>
extends AbstractChain<REQ, RESP> {
    private List<Handler<REQ, RESP>> handlers = Collects.emptyArrayList();
    private IntegerCounter posHolder;

    public FilterChain() {
        this(false);
    }

    public FilterChain(IntegerCounter posHolder) {
        this.posHolder = posHolder;
    }

    public FilterChain(boolean shareChain) {
        this.posHolder = shareChain ? new ThreadLocalIntegerCounter() : new SimpleIntegerCounter();
    }

    @Override
    public void handle(REQ request, RESP response) {
        int pos = (Integer)this.posHolder.get();
        if (pos < this.handlers.size() - 1 && pos >= -1) {
            this.posHolder.increment();
            Handler<REQ, RESP> handler = this.handlers.get(pos);
            handler.handle(request, response, this);
        }
        if (pos >= this.handlers.size() - 1) {
            this.posHolder.set(-1);
        }
    }

    @Override
    public void addHandler(@NonNull Handler<REQ, RESP> handler) {
        Preconditions.checkNotNull(handler);
        this.handlers.add(handler);
    }
}

