/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.asn1.spec;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.NotMutable;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.asn1.bytestring.ByteStringBuffer;
import com.jn.langx.asn1.spec.ASN1Constants;
import com.jn.langx.asn1.spec.ASN1Element;
import com.jn.langx.asn1.spec.ASN1Exception;
import com.jn.langx.asn1.spec.ASN1Messages;
import java.util.ArrayList;
import java.util.Collection;

@NotMutable
public final class ASN1Sequence
extends ASN1Element {
    private static final long serialVersionUID = 7294248008273774906L;
    @NonNull
    private final ASN1Element[] elements;
    @Nullable
    private byte[] encodedValue;
    @Nullable
    private volatile byte[] encodedValueGuard;

    public ASN1Sequence() {
        super((byte)48);
        this.elements = ASN1Constants.NO_ELEMENTS;
        this.encodedValue = ASN1Constants.NO_VALUE;
    }

    public ASN1Sequence(byte type) {
        super(type);
        this.elements = ASN1Constants.NO_ELEMENTS;
        this.encodedValue = ASN1Constants.NO_VALUE;
    }

    public ASN1Sequence(ASN1Element ... elements) {
        super((byte)48);
        this.elements = elements == null ? ASN1Constants.NO_ELEMENTS : elements;
        this.encodedValue = null;
    }

    public ASN1Sequence(@Nullable Collection<? extends ASN1Element> elements) {
        super((byte)48);
        if (elements == null || elements.isEmpty()) {
            this.elements = ASN1Constants.NO_ELEMENTS;
        } else {
            this.elements = new ASN1Element[elements.size()];
            elements.toArray(this.elements);
        }
        this.encodedValue = null;
    }

    public ASN1Sequence(byte type, ASN1Element ... elements) {
        super(type);
        this.elements = elements == null ? ASN1Constants.NO_ELEMENTS : elements;
        this.encodedValue = null;
    }

    public ASN1Sequence(byte type, @Nullable Collection<? extends ASN1Element> elements) {
        super(type);
        if (elements == null || elements.isEmpty()) {
            this.elements = ASN1Constants.NO_ELEMENTS;
        } else {
            this.elements = new ASN1Element[elements.size()];
            elements.toArray(this.elements);
        }
        this.encodedValue = null;
    }

    private ASN1Sequence(byte type, @NonNull ASN1Element[] elements, @NonNull byte[] value) {
        super(type);
        this.elements = elements;
        this.encodedValue = value;
    }

    @Override
    @NonNull
    byte[] getValueArray() {
        return this.getValue();
    }

    @Override
    int getValueOffset() {
        return 0;
    }

    @Override
    public int getValueLength() {
        return this.getValue().length;
    }

    @Override
    @NonNull
    public byte[] getValue() {
        if (this.encodedValue == null) {
            this.encodedValueGuard = ASN1Sequence.encodeElements(this.elements);
            this.encodedValue = this.encodedValueGuard;
        }
        return this.encodedValue;
    }

    @Override
    public void encodeTo(@NonNull ByteStringBuffer buffer) {
        buffer.append(this.getType());
        if (this.elements.length == 0) {
            buffer.append((byte)0);
            return;
        }
        int originalLength = buffer.length();
        for (ASN1Element e : this.elements) {
            e.encodeTo(buffer);
        }
        buffer.insert(originalLength, ASN1Sequence.encodeLength(buffer.length() - originalLength));
    }

    @NonNull
    static byte[] encodeElements(@Nullable ASN1Element[] elements) {
        if (elements == null || elements.length == 0) {
            return ASN1Constants.NO_VALUE;
        }
        int totalLength = 0;
        int numElements = elements.length;
        byte[][] encodedElements = new byte[numElements][];
        for (int i = 0; i < numElements; ++i) {
            encodedElements[i] = elements[i].encode();
            totalLength += encodedElements[i].length;
        }
        int pos = 0;
        byte[] b = new byte[totalLength];
        for (int i = 0; i < numElements; ++i) {
            System.arraycopy(encodedElements[i], 0, b, pos, encodedElements[i].length);
            pos += encodedElements[i].length;
        }
        return b;
    }

    @NonNull
    public ASN1Element[] elements() {
        return this.elements;
    }

    @NonNull
    public static ASN1Sequence decodeAsSequence(@NonNull byte[] elementBytes) throws ASN1Exception {
        try {
            int valueStartPos = 2;
            int length = elementBytes[1] & 0x7F;
            if (length != elementBytes[1]) {
                int numLengthBytes = length;
                length = 0;
                for (int i = 0; i < numLengthBytes; ++i) {
                    length <<= 8;
                    length |= elementBytes[valueStartPos++] & 0xFF;
                }
            }
            if (elementBytes.length - valueStartPos != length) {
                throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_LENGTH_MISMATCH.get(length, elementBytes.length - valueStartPos));
            }
            byte[] value = new byte[length];
            System.arraycopy(elementBytes, valueStartPos, value, 0, length);
            int numElements = 0;
            ArrayList<ASN1Element> elementList = new ArrayList<ASN1Element>(5);
            try {
                int pos = 0;
                while (pos < value.length) {
                    byte firstLengthByte;
                    int l;
                    byte type = value[pos++];
                    if ((l = (firstLengthByte = value[pos++]) & 0x7F) != firstLengthByte) {
                        int numLengthBytes = l;
                        l = 0;
                        for (int i = 0; i < numLengthBytes; ++i) {
                            l <<= 8;
                            l |= value[pos++] & 0xFF;
                        }
                    }
                    int posPlusLength = pos + l;
                    if (l < 0 || posPlusLength < 0 || posPlusLength > value.length) {
                        throw new ASN1Exception(ASN1Messages.ERR_SEQUENCE_BYTES_DECODE_LENGTH_EXCEEDS_AVAILABLE.get());
                    }
                    elementList.add(new ASN1Element(type, value, pos, l));
                    pos += l;
                    ++numElements;
                }
            }
            catch (ASN1Exception ae) {
                throw ae;
            }
            catch (Exception e) {
                throw new ASN1Exception(ASN1Messages.ERR_SEQUENCE_BYTES_DECODE_EXCEPTION.get(e), e);
            }
            int i = 0;
            ASN1Element[] elements = new ASN1Element[numElements];
            for (ASN1Element e : elementList) {
                elements[i++] = e;
            }
            return new ASN1Sequence(elementBytes[0], elements, value);
        }
        catch (ASN1Exception ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_DECODE_EXCEPTION.get(e), e);
        }
    }

    @NonNull
    public static ASN1Sequence decodeAsSequence(@NonNull ASN1Element element) throws ASN1Exception {
        int numElements = 0;
        ArrayList<ASN1Element> elementList = new ArrayList<ASN1Element>(5);
        byte[] value = element.getValue();
        try {
            int pos = 0;
            while (pos < value.length) {
                byte firstLengthByte;
                int length;
                byte type = value[pos++];
                if ((length = (firstLengthByte = value[pos++]) & 0x7F) != firstLengthByte) {
                    int numLengthBytes = length;
                    length = 0;
                    for (int i = 0; i < numLengthBytes; ++i) {
                        length <<= 8;
                        length |= value[pos++] & 0xFF;
                    }
                }
                int posPlusLength = pos + length;
                if (length < 0 || posPlusLength < 0 || posPlusLength > value.length) {
                    throw new ASN1Exception(ASN1Messages.ERR_SEQUENCE_DECODE_LENGTH_EXCEEDS_AVAILABLE.get(String.valueOf(element)));
                }
                elementList.add(new ASN1Element(type, value, pos, length));
                pos += length;
                ++numElements;
            }
        }
        catch (ASN1Exception ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new ASN1Exception(ASN1Messages.ERR_SEQUENCE_DECODE_EXCEPTION.get(String.valueOf(element), e), e);
        }
        int i = 0;
        ASN1Element[] elements = new ASN1Element[numElements];
        for (ASN1Element e : elementList) {
            elements[i++] = e;
        }
        return new ASN1Sequence(element.getType(), elements, value);
    }

    @Override
    public void toString(@NonNull StringBuilder buffer) {
        buffer.append('[');
        for (int i = 0; i < this.elements.length; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            this.elements[i].toString(buffer);
        }
        buffer.append(']');
    }
}

