/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.asn1.spec;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.asn1.spec.ASN1Element;
import com.jn.langx.asn1.spec.ASN1Exception;
import com.jn.langx.asn1.spec.ASN1Messages;
import com.jn.langx.util.io.unicode.Utf8s;

public final class ASN1PrintableString
extends ASN1Element {
    private static final long serialVersionUID = 7489436088285132189L;
    @NonNull
    private final String stringValue;

    public ASN1PrintableString(@Nullable String stringValue) throws ASN1Exception {
        this(19, stringValue);
    }

    public ASN1PrintableString(byte type, @Nullable String stringValue) throws ASN1Exception {
        this(type, stringValue, Utf8s.getBytes(stringValue));
    }

    private ASN1PrintableString(byte type, @Nullable String stringValue, @NonNull byte[] encodedValue) throws ASN1Exception {
        super(type, encodedValue);
        if (stringValue == null) {
            this.stringValue = "";
        } else {
            this.stringValue = stringValue;
            if (!ASN1PrintableString.isPrintableString(encodedValue)) {
                throw new ASN1Exception(ASN1Messages.ERR_PRINTABLE_STRING_DECODE_VALUE_NOT_PRINTABLE.get());
            }
        }
    }

    @NonNull
    public String stringValue() {
        return this.stringValue;
    }

    @NonNull
    public static ASN1PrintableString decodeAsPrintableString(@NonNull byte[] elementBytes) throws ASN1Exception {
        try {
            int valueStartPos = 2;
            int length = elementBytes[1] & 0x7F;
            if (length != elementBytes[1]) {
                int numLengthBytes = length;
                length = 0;
                for (int i = 0; i < numLengthBytes; ++i) {
                    length <<= 8;
                    length |= elementBytes[valueStartPos++] & 0xFF;
                }
            }
            if (elementBytes.length - valueStartPos != length) {
                throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_LENGTH_MISMATCH.get(length, elementBytes.length - valueStartPos));
            }
            byte[] elementValue = new byte[length];
            System.arraycopy(elementBytes, valueStartPos, elementValue, 0, length);
            return new ASN1PrintableString(elementBytes[0], Utf8s.toString(elementValue), elementValue);
        }
        catch (ASN1Exception ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_DECODE_EXCEPTION.get(e), e);
        }
    }

    @NonNull
    public static ASN1PrintableString decodeAsPrintableString(@NonNull ASN1Element element) throws ASN1Exception {
        byte[] elementValue = element.getValue();
        return new ASN1PrintableString(element.getType(), Utf8s.toString(elementValue), elementValue);
    }

    public static boolean isPrintableString(@NonNull byte[] b) {
        block3: for (byte by : b) {
            if ((by & 0x80) == 128) {
                return false;
            }
            if (by >= 97 && by <= 122 || by >= 65 && by <= 90 || by >= 48 && by <= 57) continue;
            switch (by) {
                case 32: 
                case 39: 
                case 40: 
                case 41: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 58: 
                case 61: 
                case 63: {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void toString(@NonNull StringBuilder buffer) {
        buffer.append(this.stringValue);
    }
}

