/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.asn1.spec;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.asn1.spec.ASN1Element;
import com.jn.langx.asn1.spec.ASN1Exception;
import com.jn.langx.asn1.spec.ASN1Messages;
import com.jn.langx.codec.hex.Hexs;

public final class ASN1Null
extends ASN1Element {
    @NonNull
    public static final ASN1Null UNIVERSAL_NULL_ELEMENT = new ASN1Null();
    private static final long serialVersionUID = -3264450066845549348L;

    public ASN1Null() {
        super((byte)5);
    }

    public ASN1Null(byte type) {
        super(type);
    }

    @NonNull
    public static ASN1Null decodeAsNull(@NonNull byte[] elementBytes) throws ASN1Exception {
        try {
            int valueStartPos = 2;
            int length = elementBytes[1] & 0x7F;
            if (length != elementBytes[1]) {
                int numLengthBytes = length;
                length = 0;
                for (int i = 0; i < numLengthBytes; ++i) {
                    length <<= 8;
                    length |= elementBytes[valueStartPos++] & 0xFF;
                }
            }
            if (elementBytes.length - valueStartPos != length) {
                throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_LENGTH_MISMATCH.get(length, elementBytes.length - valueStartPos));
            }
            if (length != 0) {
                throw new ASN1Exception(ASN1Messages.ERR_NULL_HAS_VALUE.get());
            }
            return new ASN1Null(elementBytes[0]);
        }
        catch (ASN1Exception ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_DECODE_EXCEPTION.get(e), e);
        }
    }

    @NonNull
    public static ASN1Null decodeAsNull(@NonNull ASN1Element element) throws ASN1Exception {
        if (element.getValue().length != 0) {
            throw new ASN1Exception(ASN1Messages.ERR_NULL_HAS_VALUE.get());
        }
        return new ASN1Null(element.getType());
    }

    @Override
    public void toString(@NonNull StringBuilder buffer) {
        buffer.append("ASN1Null(type=");
        Hexs.toHex(this.getType(), buffer);
        buffer.append(')');
    }
}

