/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.asn1.spec;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.NotExtensible;
import com.jn.langx.annotation.NotMutable;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.asn1.bytestring.ByteStringBuffer;
import com.jn.langx.asn1.spec.ASN1BigInteger;
import com.jn.langx.asn1.spec.ASN1BitString;
import com.jn.langx.asn1.spec.ASN1Boolean;
import com.jn.langx.asn1.spec.ASN1Constants;
import com.jn.langx.asn1.spec.ASN1Enumerated;
import com.jn.langx.asn1.spec.ASN1Exception;
import com.jn.langx.asn1.spec.ASN1GeneralizedTime;
import com.jn.langx.asn1.spec.ASN1IA5String;
import com.jn.langx.asn1.spec.ASN1Integer;
import com.jn.langx.asn1.spec.ASN1Long;
import com.jn.langx.asn1.spec.ASN1Messages;
import com.jn.langx.asn1.spec.ASN1Null;
import com.jn.langx.asn1.spec.ASN1NumericString;
import com.jn.langx.asn1.spec.ASN1ObjectIdentifier;
import com.jn.langx.asn1.spec.ASN1OctetString;
import com.jn.langx.asn1.spec.ASN1PrintableString;
import com.jn.langx.asn1.spec.ASN1Sequence;
import com.jn.langx.asn1.spec.ASN1Set;
import com.jn.langx.asn1.spec.ASN1UTCTime;
import com.jn.langx.asn1.spec.ASN1UTF8String;
import com.jn.langx.codec.hex.Hexs;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;

@NotExtensible
@NotMutable
public class ASN1Element
implements Serializable {
    private static final long serialVersionUID = -1871166128693521335L;
    private final byte type;
    @NonNull
    private final byte[] value;
    private int hashCode = -1;
    private final int valueLength;
    private final int valueOffset;

    public ASN1Element(byte type) {
        this.type = type;
        this.value = ASN1Constants.NO_VALUE;
        this.valueOffset = 0;
        this.valueLength = 0;
    }

    public ASN1Element(byte type, @Nullable byte[] value) {
        this.type = type;
        this.value = value == null ? ASN1Constants.NO_VALUE : value;
        this.valueOffset = 0;
        this.valueLength = this.value.length;
    }

    public ASN1Element(byte type, @NonNull byte[] value, int offset, int length) {
        this.type = type;
        this.value = value;
        this.valueOffset = offset;
        this.valueLength = length;
    }

    public final byte getType() {
        return this.type;
    }

    public byte getTypeClass() {
        return (byte)(this.type & 0xC0);
    }

    public boolean isConstructed() {
        return (this.type & 0x20) != 0;
    }

    @NonNull
    byte[] getValueArray() {
        return this.value;
    }

    int getValueOffset() {
        return this.valueOffset;
    }

    public int getValueLength() {
        return this.valueLength;
    }

    @NonNull
    public byte[] getValue() {
        if (this.valueOffset == 0 && this.valueLength == this.value.length) {
            return this.value;
        }
        byte[] returnValue = new byte[this.valueLength];
        System.arraycopy(this.value, this.valueOffset, returnValue, 0, this.valueLength);
        return returnValue;
    }

    @NonNull
    public final byte[] encode() {
        byte[] valueArray = this.getValueArray();
        int length = this.getValueLength();
        int offset = this.getValueOffset();
        if (length == 0) {
            return new byte[]{this.type, 0};
        }
        byte[] lengthBytes = ASN1Element.encodeLength(length);
        byte[] elementBytes = new byte[1 + lengthBytes.length + length];
        elementBytes[0] = this.type;
        System.arraycopy(lengthBytes, 0, elementBytes, 1, lengthBytes.length);
        System.arraycopy(valueArray, offset, elementBytes, 1 + lengthBytes.length, length);
        return elementBytes;
    }

    static void encodeLengthTo(int length, @NonNull ByteStringBuffer buffer) {
        if ((length & 0x7F) == length) {
            buffer.append((byte)length);
        } else if ((length & 0xFF) == length) {
            buffer.append((byte)-127);
            buffer.append((byte)(length & 0xFF));
        } else if ((length & 0xFFFF) == length) {
            buffer.append((byte)-126);
            buffer.append((byte)(length >> 8 & 0xFF));
            buffer.append((byte)(length & 0xFF));
        } else if ((length & 0xFFFFFF) == length) {
            buffer.append((byte)-125);
            buffer.append((byte)(length >> 16 & 0xFF));
            buffer.append((byte)(length >> 8 & 0xFF));
            buffer.append((byte)(length & 0xFF));
        } else {
            buffer.append((byte)-124);
            buffer.append((byte)(length >> 24 & 0xFF));
            buffer.append((byte)(length >> 16 & 0xFF));
            buffer.append((byte)(length >> 8 & 0xFF));
            buffer.append((byte)(length & 0xFF));
        }
    }

    public void encodeTo(@NonNull ByteStringBuffer buffer) {
        byte[] valueArray = this.getValueArray();
        int length = this.getValueLength();
        int offset = this.getValueOffset();
        buffer.append(this.type);
        if (length == 0) {
            buffer.append((byte)0);
        } else {
            ASN1Element.encodeLengthTo(length, buffer);
            buffer.append(valueArray, offset, length);
        }
    }

    @NonNull
    public static byte[] encodeLength(int length) {
        switch (length) {
            case 0: {
                return ASN1Constants.LENGTH_0;
            }
            case 1: {
                return ASN1Constants.LENGTH_1;
            }
            case 2: {
                return ASN1Constants.LENGTH_2;
            }
            case 3: {
                return ASN1Constants.LENGTH_3;
            }
            case 4: {
                return ASN1Constants.LENGTH_4;
            }
            case 5: {
                return ASN1Constants.LENGTH_5;
            }
            case 6: {
                return ASN1Constants.LENGTH_6;
            }
            case 7: {
                return ASN1Constants.LENGTH_7;
            }
            case 8: {
                return ASN1Constants.LENGTH_8;
            }
            case 9: {
                return ASN1Constants.LENGTH_9;
            }
            case 10: {
                return ASN1Constants.LENGTH_10;
            }
            case 11: {
                return ASN1Constants.LENGTH_11;
            }
            case 12: {
                return ASN1Constants.LENGTH_12;
            }
            case 13: {
                return ASN1Constants.LENGTH_13;
            }
            case 14: {
                return ASN1Constants.LENGTH_14;
            }
            case 15: {
                return ASN1Constants.LENGTH_15;
            }
            case 16: {
                return ASN1Constants.LENGTH_16;
            }
            case 17: {
                return ASN1Constants.LENGTH_17;
            }
            case 18: {
                return ASN1Constants.LENGTH_18;
            }
            case 19: {
                return ASN1Constants.LENGTH_19;
            }
            case 20: {
                return ASN1Constants.LENGTH_20;
            }
            case 21: {
                return ASN1Constants.LENGTH_21;
            }
            case 22: {
                return ASN1Constants.LENGTH_22;
            }
            case 23: {
                return ASN1Constants.LENGTH_23;
            }
            case 24: {
                return ASN1Constants.LENGTH_24;
            }
            case 25: {
                return ASN1Constants.LENGTH_25;
            }
            case 26: {
                return ASN1Constants.LENGTH_26;
            }
            case 27: {
                return ASN1Constants.LENGTH_27;
            }
            case 28: {
                return ASN1Constants.LENGTH_28;
            }
            case 29: {
                return ASN1Constants.LENGTH_29;
            }
            case 30: {
                return ASN1Constants.LENGTH_30;
            }
            case 31: {
                return ASN1Constants.LENGTH_31;
            }
            case 32: {
                return ASN1Constants.LENGTH_32;
            }
            case 33: {
                return ASN1Constants.LENGTH_33;
            }
            case 34: {
                return ASN1Constants.LENGTH_34;
            }
            case 35: {
                return ASN1Constants.LENGTH_35;
            }
            case 36: {
                return ASN1Constants.LENGTH_36;
            }
            case 37: {
                return ASN1Constants.LENGTH_37;
            }
            case 38: {
                return ASN1Constants.LENGTH_38;
            }
            case 39: {
                return ASN1Constants.LENGTH_39;
            }
            case 40: {
                return ASN1Constants.LENGTH_40;
            }
            case 41: {
                return ASN1Constants.LENGTH_41;
            }
            case 42: {
                return ASN1Constants.LENGTH_42;
            }
            case 43: {
                return ASN1Constants.LENGTH_43;
            }
            case 44: {
                return ASN1Constants.LENGTH_44;
            }
            case 45: {
                return ASN1Constants.LENGTH_45;
            }
            case 46: {
                return ASN1Constants.LENGTH_46;
            }
            case 47: {
                return ASN1Constants.LENGTH_47;
            }
            case 48: {
                return ASN1Constants.LENGTH_48;
            }
            case 49: {
                return ASN1Constants.LENGTH_49;
            }
            case 50: {
                return ASN1Constants.LENGTH_50;
            }
            case 51: {
                return ASN1Constants.LENGTH_51;
            }
            case 52: {
                return ASN1Constants.LENGTH_52;
            }
            case 53: {
                return ASN1Constants.LENGTH_53;
            }
            case 54: {
                return ASN1Constants.LENGTH_54;
            }
            case 55: {
                return ASN1Constants.LENGTH_55;
            }
            case 56: {
                return ASN1Constants.LENGTH_56;
            }
            case 57: {
                return ASN1Constants.LENGTH_57;
            }
            case 58: {
                return ASN1Constants.LENGTH_58;
            }
            case 59: {
                return ASN1Constants.LENGTH_59;
            }
            case 60: {
                return ASN1Constants.LENGTH_60;
            }
            case 61: {
                return ASN1Constants.LENGTH_61;
            }
            case 62: {
                return ASN1Constants.LENGTH_62;
            }
            case 63: {
                return ASN1Constants.LENGTH_63;
            }
            case 64: {
                return ASN1Constants.LENGTH_64;
            }
            case 65: {
                return ASN1Constants.LENGTH_65;
            }
            case 66: {
                return ASN1Constants.LENGTH_66;
            }
            case 67: {
                return ASN1Constants.LENGTH_67;
            }
            case 68: {
                return ASN1Constants.LENGTH_68;
            }
            case 69: {
                return ASN1Constants.LENGTH_69;
            }
            case 70: {
                return ASN1Constants.LENGTH_70;
            }
            case 71: {
                return ASN1Constants.LENGTH_71;
            }
            case 72: {
                return ASN1Constants.LENGTH_72;
            }
            case 73: {
                return ASN1Constants.LENGTH_73;
            }
            case 74: {
                return ASN1Constants.LENGTH_74;
            }
            case 75: {
                return ASN1Constants.LENGTH_75;
            }
            case 76: {
                return ASN1Constants.LENGTH_76;
            }
            case 77: {
                return ASN1Constants.LENGTH_77;
            }
            case 78: {
                return ASN1Constants.LENGTH_78;
            }
            case 79: {
                return ASN1Constants.LENGTH_79;
            }
            case 80: {
                return ASN1Constants.LENGTH_80;
            }
            case 81: {
                return ASN1Constants.LENGTH_81;
            }
            case 82: {
                return ASN1Constants.LENGTH_82;
            }
            case 83: {
                return ASN1Constants.LENGTH_83;
            }
            case 84: {
                return ASN1Constants.LENGTH_84;
            }
            case 85: {
                return ASN1Constants.LENGTH_85;
            }
            case 86: {
                return ASN1Constants.LENGTH_86;
            }
            case 87: {
                return ASN1Constants.LENGTH_87;
            }
            case 88: {
                return ASN1Constants.LENGTH_88;
            }
            case 89: {
                return ASN1Constants.LENGTH_89;
            }
            case 90: {
                return ASN1Constants.LENGTH_90;
            }
            case 91: {
                return ASN1Constants.LENGTH_91;
            }
            case 92: {
                return ASN1Constants.LENGTH_92;
            }
            case 93: {
                return ASN1Constants.LENGTH_93;
            }
            case 94: {
                return ASN1Constants.LENGTH_94;
            }
            case 95: {
                return ASN1Constants.LENGTH_95;
            }
            case 96: {
                return ASN1Constants.LENGTH_96;
            }
            case 97: {
                return ASN1Constants.LENGTH_97;
            }
            case 98: {
                return ASN1Constants.LENGTH_98;
            }
            case 99: {
                return ASN1Constants.LENGTH_99;
            }
            case 100: {
                return ASN1Constants.LENGTH_100;
            }
            case 101: {
                return ASN1Constants.LENGTH_101;
            }
            case 102: {
                return ASN1Constants.LENGTH_102;
            }
            case 103: {
                return ASN1Constants.LENGTH_103;
            }
            case 104: {
                return ASN1Constants.LENGTH_104;
            }
            case 105: {
                return ASN1Constants.LENGTH_105;
            }
            case 106: {
                return ASN1Constants.LENGTH_106;
            }
            case 107: {
                return ASN1Constants.LENGTH_107;
            }
            case 108: {
                return ASN1Constants.LENGTH_108;
            }
            case 109: {
                return ASN1Constants.LENGTH_109;
            }
            case 110: {
                return ASN1Constants.LENGTH_110;
            }
            case 111: {
                return ASN1Constants.LENGTH_111;
            }
            case 112: {
                return ASN1Constants.LENGTH_112;
            }
            case 113: {
                return ASN1Constants.LENGTH_113;
            }
            case 114: {
                return ASN1Constants.LENGTH_114;
            }
            case 115: {
                return ASN1Constants.LENGTH_115;
            }
            case 116: {
                return ASN1Constants.LENGTH_116;
            }
            case 117: {
                return ASN1Constants.LENGTH_117;
            }
            case 118: {
                return ASN1Constants.LENGTH_118;
            }
            case 119: {
                return ASN1Constants.LENGTH_119;
            }
            case 120: {
                return ASN1Constants.LENGTH_120;
            }
            case 121: {
                return ASN1Constants.LENGTH_121;
            }
            case 122: {
                return ASN1Constants.LENGTH_122;
            }
            case 123: {
                return ASN1Constants.LENGTH_123;
            }
            case 124: {
                return ASN1Constants.LENGTH_124;
            }
            case 125: {
                return ASN1Constants.LENGTH_125;
            }
            case 126: {
                return ASN1Constants.LENGTH_126;
            }
            case 127: {
                return ASN1Constants.LENGTH_127;
            }
        }
        if ((length & 0xFF) == length) {
            return new byte[]{-127, (byte)(length & 0xFF)};
        }
        if ((length & 0xFFFF) == length) {
            return new byte[]{-126, (byte)(length >> 8 & 0xFF), (byte)(length & 0xFF)};
        }
        if ((length & 0xFFFFFF) == length) {
            return new byte[]{-125, (byte)(length >> 16 & 0xFF), (byte)(length >> 8 & 0xFF), (byte)(length & 0xFF)};
        }
        return new byte[]{-124, (byte)(length >> 24 & 0xFF), (byte)(length >> 16 & 0xFF), (byte)(length >> 8 & 0xFF), (byte)(length & 0xFF)};
    }

    @NonNull
    public static ASN1Element decode(@NonNull byte[] elementBytes) throws ASN1Exception {
        try {
            int valueStartPos = 2;
            int length = elementBytes[1] & 0x7F;
            if (length != elementBytes[1]) {
                int numLengthBytes = length;
                length = 0;
                for (int i = 0; i < numLengthBytes; ++i) {
                    length <<= 8;
                    length |= elementBytes[valueStartPos++] & 0xFF;
                }
            }
            if (elementBytes.length - valueStartPos != length) {
                throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_LENGTH_MISMATCH.get(length, elementBytes.length - valueStartPos));
            }
            byte[] value = new byte[length];
            System.arraycopy(elementBytes, valueStartPos, value, 0, length);
            return new ASN1Element(elementBytes[0], value);
        }
        catch (ASN1Exception ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_DECODE_EXCEPTION.get(e), e);
        }
    }

    @NonNull
    public final ASN1BitString decodeAsBitString() throws ASN1Exception {
        return ASN1BitString.decodeAsBitString(this);
    }

    @NonNull
    public final ASN1Boolean decodeAsBoolean() throws ASN1Exception {
        return ASN1Boolean.decodeAsBoolean(this);
    }

    @NonNull
    public final ASN1Enumerated decodeAsEnumerated() throws ASN1Exception {
        return ASN1Enumerated.decodeAsEnumerated(this);
    }

    @NonNull
    public final ASN1GeneralizedTime decodeAsGeneralizedTime() throws ASN1Exception {
        return ASN1GeneralizedTime.decodeAsGeneralizedTime(this);
    }

    @NonNull
    public final ASN1IA5String decodeAsIA5String() throws ASN1Exception {
        return ASN1IA5String.decodeAsIA5String(this);
    }

    @NonNull
    public final ASN1Integer decodeAsInteger() throws ASN1Exception {
        return ASN1Integer.decodeAsInteger(this);
    }

    @NonNull
    public final ASN1Long decodeAsLong() throws ASN1Exception {
        return ASN1Long.decodeAsLong(this);
    }

    @NonNull
    public final ASN1BigInteger decodeAsBigInteger() throws ASN1Exception {
        return ASN1BigInteger.decodeAsBigInteger(this);
    }

    @NonNull
    public final ASN1Null decodeAsNull() throws ASN1Exception {
        return ASN1Null.decodeAsNull(this);
    }

    @NonNull
    public final ASN1NumericString decodeAsNumericString() throws ASN1Exception {
        return ASN1NumericString.decodeAsNumericString(this);
    }

    @NonNull
    public final ASN1ObjectIdentifier decodeAsObjectIdentifier() throws ASN1Exception {
        return ASN1ObjectIdentifier.decodeAsObjectIdentifier(this);
    }

    @NonNull
    public final ASN1OctetString decodeAsOctetString() {
        return ASN1OctetString.decodeAsOctetString(this);
    }

    @NonNull
    public final ASN1PrintableString decodeAsPrintableString() throws ASN1Exception {
        return ASN1PrintableString.decodeAsPrintableString(this);
    }

    @NonNull
    public final ASN1Sequence decodeAsSequence() throws ASN1Exception {
        return ASN1Sequence.decodeAsSequence(this);
    }

    @NonNull
    public final ASN1Set decodeAsSet() throws ASN1Exception {
        return ASN1Set.decodeAsSet(this);
    }

    @NonNull
    public final ASN1UTCTime decodeAsUTCTime() throws ASN1Exception {
        return ASN1UTCTime.decodeAsUTCTime(this);
    }

    @NonNull
    public final ASN1UTF8String decodeAsUTF8String() throws ASN1Exception {
        return ASN1UTF8String.decodeAsUTF8String(this);
    }

    @Nullable
    public static ASN1Element readFrom(@NonNull InputStream inputStream) throws IOException, ASN1Exception {
        return ASN1Element.readFrom(inputStream, -1);
    }

    @Nullable
    public static ASN1Element readFrom(@NonNull InputStream inputStream, int maxSize) throws IOException, ASN1Exception {
        int typeInt = inputStream.read();
        if (typeInt < 0) {
            return null;
        }
        byte type = (byte)typeInt;
        int length = inputStream.read();
        if (length < 0) {
            throw new ASN1Exception(ASN1Messages.ERR_READ_END_BEFORE_FIRST_LENGTH.get());
        }
        if (length > 127) {
            int numLengthBytes = length & 0x7F;
            length = 0;
            if (numLengthBytes < 1 || numLengthBytes > 4) {
                throw new ASN1Exception(ASN1Messages.ERR_READ_LENGTH_TOO_LONG.get(numLengthBytes));
            }
            for (int i = 0; i < numLengthBytes; ++i) {
                int lengthInt = inputStream.read();
                if (lengthInt < 0) {
                    throw new ASN1Exception(ASN1Messages.ERR_READ_END_BEFORE_LENGTH_END.get());
                }
                length <<= 8;
                length |= lengthInt & 0xFF;
            }
        }
        if (length < 0 || maxSize > 0 && length > maxSize) {
            throw new ASN1Exception(ASN1Messages.ERR_READ_LENGTH_EXCEEDS_MAX.get(length, maxSize));
        }
        int totalBytesRead = 0;
        int bytesRemaining = length;
        byte[] value = new byte[length];
        while (totalBytesRead < length) {
            int bytesRead = inputStream.read(value, totalBytesRead, bytesRemaining);
            if (bytesRead < 0) {
                throw new ASN1Exception(ASN1Messages.ERR_READ_END_BEFORE_VALUE_END.get());
            }
            totalBytesRead += bytesRead;
            bytesRemaining -= bytesRead;
        }
        ASN1Element e = new ASN1Element(type, value);
        return e;
    }

    public final int writeTo(@NonNull OutputStream outputStream) throws IOException {
        ByteStringBuffer buffer = new ByteStringBuffer();
        this.encodeTo(buffer);
        buffer.write(outputStream);
        return buffer.length();
    }

    public final int hashCode() {
        if (this.hashCode == -1) {
            int hash = 0;
            for (byte b : this.getValue()) {
                hash = hash * 31 + b;
            }
            this.hashCode = hash;
        }
        return this.hashCode;
    }

    public final boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        try {
            ASN1Element e = (ASN1Element)o;
            return this.type == e.getType() && Arrays.equals(this.getValue(), e.getValue());
        }
        catch (Exception e) {
            return false;
        }
    }

    public final boolean equalsIgnoreType(@Nullable ASN1Element element) {
        if (element == null) {
            return false;
        }
        if (element == this) {
            return true;
        }
        return Arrays.equals(this.getValue(), element.getValue());
    }

    @NonNull
    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NonNull StringBuilder buffer) {
        byte[] v = this.getValue();
        buffer.append("ASN1Element(type=");
        Hexs.toHex(this.type, buffer);
        buffer.append(", valueLength=");
        buffer.append(v.length);
        buffer.append(", valueBytes='");
        Hexs.toHex(v, buffer);
        buffer.append("')");
    }
}

