/*
 * Decompiled with CFR 0.152.
 */
package com.jn.easyjson.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.jn.easyjson.jackson.Jacksons;
import com.jn.easyjson.jackson.serializer.ContextualSerializer;
import com.jn.langx.util.reflect.type.Types;
import java.io.IOException;
import java.lang.reflect.Type;

public class NumberSerializer
extends JsonSerializer<Number>
implements ContextualSerializer {
    public void serialize(Number value, JsonGenerator gen, SerializerProvider sp) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }
        boolean longUsingString = Jacksons.getBoolean(sp.getAttribute((Object)"SERIALIZE_LONG_USING_STRING"));
        boolean usingString = Jacksons.getBoolean(sp.getAttribute((Object)"SERIALIZE_NUMBER_USING_STRING"));
        if (longUsingString) {
            Class<?> typeOfSrc = value.getClass();
            if (Long.class == typeOfSrc || Long.TYPE == typeOfSrc) {
                gen.writeString(value.toString());
                return;
            }
            gen.writeNumber(value.toString());
            return;
        }
        if (usingString) {
            gen.writeString(value.toString());
            return;
        }
        gen.writeNumber(value.toString());
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property, JavaType type) throws JsonMappingException {
        if (type == null) {
            return null;
        }
        Class rawType = type.getRawClass();
        String clsName = rawType.getName();
        if ((Types.isPrimitive((Type)rawType) || clsName.startsWith("java.")) && (Jacksons.getBoolean(prov.getAttribute((Object)"SERIALIZE_NUMBER_USING_STRING")) || Jacksons.getBoolean(prov.getAttribute((Object)"SERIALIZE_LONG_USING_STRING")))) {
            return this;
        }
        return null;
    }
}

