/*
 * Decompiled with CFR 0.152.
 */
package com.jn.easyjson.jackson.serializer;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.jn.easyjson.core.codec.dialect.PropertyCodecConfiguration;
import com.jn.easyjson.jackson.Jacksons;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.enums.Enums;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.reflect.Reflects;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Collection;

public class EnumSerializer<T extends Enum>
extends JsonSerializer<T> {
    public void serialize(T e, JsonGenerator gen, SerializerProvider sp) throws IOException {
        Collection fields;
        Field field;
        PropertyCodecConfiguration propertyCodecConfiguration;
        if (e == null) {
            gen.writeNull();
            return;
        }
        Boolean usingIndex = null;
        Boolean usingToString = null;
        if (Jacksons.getBooleanAttr(sp, "ENABLE_CUSTOM_CONFIGURATION") && (propertyCodecConfiguration = Jacksons.getPropertyCodecConfiguration(gen)) != null) {
            usingIndex = propertyCodecConfiguration.getEnumUsingIndex();
            usingToString = propertyCodecConfiguration.getEnumUsingToString();
        }
        if (usingIndex == null) {
            usingIndex = sp.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX);
        }
        if (usingToString == null) {
            usingToString = sp.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        }
        String usingField = (String)sp.getAttribute((Object)"SERIALIZE_ENUM_USING_FIELD");
        if (usingIndex.booleanValue()) {
            gen.writeNumber(((Enum)e).ordinal());
            return;
        }
        if (usingToString.booleanValue()) {
            gen.writeString(((Enum)e).toString());
            return;
        }
        if (Strings.isEmpty((String)usingField) && (field = (Field)Pipeline.of((Iterable)(fields = Reflects.getAllDeclaredFields(e.getClass(), (boolean)false))).findFirst((Predicate)new Predicate<Field>(){

            public boolean test(Field field) {
                return Reflects.hasAnnotation((AnnotatedElement)field, JsonValue.class);
            }
        })) != null) {
            usingField = field.getName();
        }
        if (Strings.isNotEmpty((String)usingField)) {
            usingField = usingField.trim();
            try {
                Field field2 = e.getClass().getDeclaredField(usingField);
                field2.setAccessible(true);
                Class<?> fieldClazz = field2.getType();
                if (fieldClazz.isArray() || fieldClazz.isAnonymousClass() || fieldClazz.isAnnotation() || fieldClazz.isSynthetic()) {
                    throw new UnsupportedOperationException();
                }
                if (fieldClazz == String.class) {
                    gen.writeString(field2.get(e).toString());
                    return;
                }
                if (fieldClazz == Character.class) {
                    gen.writeRaw(((Character)field2.get(e)).charValue());
                    return;
                }
                if (fieldClazz == Boolean.class) {
                    gen.writeBoolean(((Boolean)field2.get(e)).booleanValue());
                    return;
                }
                if (Number.class.isAssignableFrom(fieldClazz)) {
                    gen.writeNumber(((Number)field2.get(e)).toString());
                    return;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        gen.writeString(Enums.getName(e));
    }
}

