/*
 * Decompiled with CFR 0.152.
 */
package com.jn.easyjson.jackson.modifier;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.jn.easyjson.jackson.DateSeries;
import com.jn.easyjson.jackson.deserializer.BooleanDeserializer;
import com.jn.easyjson.jackson.deserializer.DateDeserializer;
import com.jn.easyjson.jackson.deserializer.EnumDeserializer;
import com.jn.easyjson.jackson.deserializer.NumberDeserializer;
import com.jn.langx.util.reflect.type.Types;
import java.lang.reflect.Type;

public class EasyjsonBeanDeserializerModifier
extends BeanDeserializerModifier {
    public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
        Class beanClass = beanDesc.getBeanClass();
        if (Boolean.class == beanClass || Boolean.TYPE == beanClass) {
            return new BooleanDeserializer();
        }
        if (Types.isPrimitive((Type)beanClass) && Number.class.isAssignableFrom(Types.getPrimitiveWrapClass((Type)beanClass))) {
            return new NumberDeserializer(beanClass);
        }
        if (DateSeries.isSupported(beanClass)) {
            return new DateDeserializer(beanClass);
        }
        if (beanClass.isEnum()) {
            return new EnumDeserializer(beanClass);
        }
        return super.modifyDeserializer(config, beanDesc, deserializer);
    }
}

