/*
 * Decompiled with CFR 0.152.
 */
package com.jn.easyjson.jackson.ext;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.jn.easyjson.core.exclusion.ExclusionConfiguration;
import com.jn.easyjson.core.util.JSONs;
import com.jn.easyjson.jackson.ext.EasyJsonObjectMapper;
import com.jn.langx.util.reflect.Reflects;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EasyJsonBeanSerializerFactory
extends BeanSerializerFactory {
    private EasyJsonObjectMapper objectMapper;

    EasyJsonBeanSerializerFactory(SerializerFactoryConfig config, EasyJsonObjectMapper objectMapper) {
        super(config);
        this.objectMapper = objectMapper;
    }

    public SerializerFactory withConfig(SerializerFactoryConfig config) {
        if (this._factoryConfig == config) {
            return this;
        }
        if (((Object)((Object)this)).getClass() != EasyJsonBeanSerializerFactory.class) {
            throw new IllegalStateException("Subtype of BeanSerializerFactory (" + ((Object)((Object)this)).getClass().getName() + ") has not properly overridden method 'withAdditionalSerializers': cannot instantiate subtype with additional serializer definitions");
        }
        return new EasyJsonBeanSerializerFactory(config, this.objectMapper);
    }

    public JsonSerializer<Object> createSerializer(SerializerProvider prov, JavaType origType) throws JsonMappingException {
        Class rawClass = origType.getRawClass();
        if (Reflects.isSubClassOrEquals(Map.Entry.class, (Class)rawClass) && JSONs.hasOtherPropertiesForMapEntry((Class)rawClass)) {
            BeanDescription beanDesc = prov.getConfig().introspect(origType);
            return this.findBeanSerializer(prov, origType, beanDesc);
        }
        return super.createSerializer(prov, origType);
    }

    protected List<BeanPropertyWriter> findBeanProperties(SerializerProvider prov, BeanDescription beanDesc, BeanSerializerBuilder builder) throws JsonMappingException {
        if (this.objectMapper != null && this.objectMapper.getJsonBuilder() != null) {
            ExclusionConfiguration exclusionConfiguration = this.objectMapper.getJsonBuilder().getExclusionConfiguration();
            Class clazz = beanDesc.getType().getRawClass();
            List properties = beanDesc.findProperties();
            if (!exclusionConfiguration.isExcludedClass(clazz, true)) {
                Iterator iter = properties.iterator();
                while (iter.hasNext()) {
                    Field field;
                    BeanPropertyDefinition property = (BeanPropertyDefinition)iter.next();
                    if (!property.hasField() || !exclusionConfiguration.isExcludedField(field = property.getField().getAnnotated(), true)) continue;
                    iter.remove();
                }
            } else {
                properties.clear();
            }
        }
        return super.findBeanProperties(prov, beanDesc, builder);
    }
}

