/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.range;

import io.github.benas.randombeans.randomizers.range.AbstractRangeRandomizer;
import io.github.benas.randombeans.util.Constants;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;

public class YearMonthRangeRandomizer
extends AbstractRangeRandomizer<YearMonth> {
    public YearMonthRangeRandomizer(YearMonth min, YearMonth max) {
        super(min, max);
    }

    public YearMonthRangeRandomizer(YearMonth min, YearMonth max, long seed) {
        super(min, max, seed);
    }

    public static YearMonthRangeRandomizer aNewYearMonthRangeRandomizer(YearMonth min, YearMonth max) {
        return new YearMonthRangeRandomizer(min, max);
    }

    public static YearMonthRangeRandomizer aNewYearMonthRangeRandomizer(YearMonth min, YearMonth max, long seed) {
        return new YearMonthRangeRandomizer(min, max, seed);
    }

    @Override
    protected void checkValues() {
        if (((YearMonth)this.min).isAfter((YearMonth)this.max)) {
            throw new IllegalArgumentException("max must be after min");
        }
    }

    @Override
    protected YearMonth getDefaultMinValue() {
        ZonedDateTime defaultDateMin = Constants.DEFAULT_DATES_RANGE.getMin();
        return YearMonth.of(defaultDateMin.getYear(), defaultDateMin.getMonth());
    }

    @Override
    protected YearMonth getDefaultMaxValue() {
        ZonedDateTime defaultDateMax = Constants.DEFAULT_DATES_RANGE.getMax();
        return YearMonth.of(defaultDateMax.getYear(), defaultDateMax.getMonth());
    }

    @Override
    public YearMonth getRandomValue() {
        long minYear = ((YearMonth)this.min).getLong(ChronoField.YEAR);
        long maxYear = ((YearMonth)this.max).getLong(ChronoField.YEAR);
        long randomYear = (long)this.nextDouble(minYear, maxYear);
        long minMonth = ((YearMonth)this.min).getLong(ChronoField.MONTH_OF_YEAR);
        long maxMonth = ((YearMonth)this.max).getLong(ChronoField.MONTH_OF_YEAR);
        long randomMonth = (long)this.nextDouble(minMonth, maxMonth);
        return YearMonth.of(Math.toIntExact(randomYear), Math.toIntExact(randomMonth));
    }
}

