/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans;

import io.github.benas.randombeans.EnhancedRandomImpl;
import io.github.benas.randombeans.RandomizationContext;
import io.github.benas.randombeans.RandomizerProvider;
import io.github.benas.randombeans.api.ContextAwareRandomizer;
import io.github.benas.randombeans.api.Randomizer;
import java.lang.reflect.Array;

class ArrayPopulator {
    private final EnhancedRandomImpl enhancedRandom;
    private final RandomizerProvider randomizerProvider;

    ArrayPopulator(EnhancedRandomImpl enhancedRandom, RandomizerProvider randomizerProvider) {
        this.enhancedRandom = enhancedRandom;
        this.randomizerProvider = randomizerProvider;
    }

    <T> Object getRandomArray(Class<?> fieldType, RandomizationContext context) {
        Class<?> componentType = fieldType.getComponentType();
        if (componentType.isPrimitive()) {
            return this.getRandomPrimitiveArray(componentType, context);
        }
        int randomSize = this.enhancedRandom.getRandomCollectionSize();
        Object[] itemsList = (Object[])Array.newInstance(componentType, randomSize);
        for (int i = 0; i < randomSize; ++i) {
            itemsList[i] = this.enhancedRandom.doPopulateBean(fieldType.getComponentType(), context);
        }
        return itemsList;
    }

    Object getRandomPrimitiveArray(Class<?> primitiveType, RandomizationContext context) {
        int randomSize = Math.abs((byte)this.enhancedRandom.nextInt());
        Randomizer<?> randomizer = this.randomizerProvider.getRandomizerByType(primitiveType);
        if (randomizer instanceof ContextAwareRandomizer) {
            ((ContextAwareRandomizer)randomizer).setRandomizerContext(context);
        }
        Object result = Array.newInstance(primitiveType, randomSize);
        for (int index = 0; index < randomSize; ++index) {
            Array.set(result, index, randomizer.getRandomValue());
        }
        return result;
    }
}

