/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.time;

import io.github.benas.randombeans.randomizers.AbstractRandomizer;
import io.github.benas.randombeans.randomizers.time.LocalDateTimeRandomizer;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Set;

public class ZonedDateTimeRandomizer
extends AbstractRandomizer<ZonedDateTime> {
    private LocalDateTimeRandomizer localDateTimeRandomizer;

    public ZonedDateTimeRandomizer() {
        this.localDateTimeRandomizer = new LocalDateTimeRandomizer();
    }

    public ZonedDateTimeRandomizer(long seed) {
        super(seed);
        this.localDateTimeRandomizer = new LocalDateTimeRandomizer(seed);
    }

    public static ZonedDateTimeRandomizer aNewZonedDateTimeRandomizer() {
        return new ZonedDateTimeRandomizer();
    }

    public static ZonedDateTimeRandomizer aNewZonedDateTimeRandomizer(long seed) {
        return new ZonedDateTimeRandomizer(seed);
    }

    @Override
    public ZonedDateTime getRandomValue() {
        LocalDateTime randomLocalDateTime = this.localDateTimeRandomizer.getRandomValue();
        ZoneId randomZoneId = this.getRandomZoneId();
        return ZonedDateTime.of(randomLocalDateTime, randomZoneId);
    }

    private ZoneId getRandomZoneId() {
        Set<String> availableZoneIds = ZoneOffset.getAvailableZoneIds();
        ArrayList<String> ids = new ArrayList<String>(availableZoneIds);
        return ZoneId.of((String)ids.get(this.random.nextInt(ids.size())));
    }

    public void setLocalDateTimeRandomizer(LocalDateTimeRandomizer localDateTimeRandomizer) {
        this.localDateTimeRandomizer = localDateTimeRandomizer;
    }
}

