/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans;

import io.github.benas.randombeans.ArrayPopulator;
import io.github.benas.randombeans.CollectionPopulator;
import io.github.benas.randombeans.EnhancedRandomImpl;
import io.github.benas.randombeans.MapPopulator;
import io.github.benas.randombeans.RandomizationContext;
import io.github.benas.randombeans.RandomizationContextStackItem;
import io.github.benas.randombeans.RandomizerProvider;
import io.github.benas.randombeans.api.ObjectGenerationException;
import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.randomizers.misc.SkipRandomizer;
import io.github.benas.randombeans.util.CollectionUtils;
import io.github.benas.randombeans.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

class FieldPopulator {
    private final EnhancedRandomImpl beanPopulator;
    private final ArrayPopulator arrayPopulator;
    private final CollectionPopulator collectionPopulator;
    private final MapPopulator mapPopulator;
    private final RandomizerProvider randomizerProvider;
    private boolean scanClasspathForConcreteTypes;

    FieldPopulator(EnhancedRandomImpl beanPopulator, RandomizerProvider randomizerProvider, ArrayPopulator arrayPopulator, CollectionPopulator collectionPopulator, MapPopulator mapPopulator) {
        this.beanPopulator = beanPopulator;
        this.randomizerProvider = randomizerProvider;
        this.arrayPopulator = arrayPopulator;
        this.collectionPopulator = collectionPopulator;
        this.mapPopulator = mapPopulator;
    }

    void populateField(Object target, Field field, RandomizationContext context) throws IllegalAccessException {
        Randomizer<?> randomizer = this.randomizerProvider.getRandomizerByField(field);
        if (randomizer instanceof SkipRandomizer) {
            return;
        }
        context.pushStackItem(new RandomizationContextStackItem(target, field));
        if (!context.hasExceededRandomizationDepth()) {
            Object value;
            if (randomizer != null) {
                value = randomizer.getRandomValue();
            } else {
                try {
                    value = this.generateRandomValue(field, context);
                }
                catch (ObjectGenerationException e) {
                    String exceptionMessage = String.format("Unable to create type: %s for field: %s of class: %s", field.getType().getName(), field.getName(), target.getClass().getName());
                    throw new ObjectGenerationException(exceptionMessage, e);
                }
            }
            ReflectionUtils.setProperty(target, field, value);
        }
        context.popStackItem();
    }

    private Object generateRandomValue(Field field, RandomizationContext context) {
        Object value;
        Class<?> fieldType = field.getType();
        Type fieldGenericType = field.getGenericType();
        if (ReflectionUtils.isArrayType(fieldType)) {
            value = this.arrayPopulator.getRandomArray(fieldType, context);
        } else if (ReflectionUtils.isCollectionType(fieldType)) {
            value = this.collectionPopulator.getRandomCollection(field, context);
        } else if (ReflectionUtils.isMapType(fieldType)) {
            value = this.mapPopulator.getRandomMap(field, context);
        } else if (this.scanClasspathForConcreteTypes && ReflectionUtils.isAbstract(fieldType) && !ReflectionUtils.isEnumType(fieldType)) {
            Class<?> randomConcreteSubType = CollectionUtils.randomElementOf(ReflectionUtils.filterSameParameterizedTypes(ReflectionUtils.getPublicConcreteSubTypesOf(fieldType), fieldGenericType));
            if (randomConcreteSubType == null) {
                throw new ObjectGenerationException("Unable to find a matching concrete subtype of type: " + fieldType);
            }
            value = this.beanPopulator.doPopulateBean(randomConcreteSubType, context);
        } else {
            value = this.beanPopulator.doPopulateBean(fieldType, context);
        }
        return value;
    }

    void setScanClasspathForConcreteTypes(boolean scanClasspathForConcreteTypes) {
        this.scanClasspathForConcreteTypes = scanClasspathForConcreteTypes;
    }
}

