/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.misc;

import io.github.benas.randombeans.randomizers.AbstractRandomizer;

public class EnumRandomizer<E extends Enum<E>>
extends AbstractRandomizer<E> {
    private final Class<E> enumeration;

    public EnumRandomizer(Class<E> enumeration) {
        this.enumeration = enumeration;
    }

    public EnumRandomizer(Class<E> enumeration, long seed) {
        super(seed);
        this.enumeration = enumeration;
    }

    public static <E extends Enum<E>> EnumRandomizer<E> aNewEnumRandomizer(Class<E> enumeration) {
        return new EnumRandomizer<E>(enumeration);
    }

    public static <E extends Enum<E>> EnumRandomizer<E> aNewEnumRandomizer(Class<E> enumeration, long seed) {
        return new EnumRandomizer<E>(enumeration, seed);
    }

    @Override
    public E getRandomValue() {
        Enum[] enumConstants = (Enum[])this.enumeration.getEnumConstants();
        int randomIndex = this.random.nextInt(enumConstants.length);
        return (E)enumConstants[randomIndex];
    }
}

