/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.registry;

import io.github.benas.randombeans.FieldDefinition;
import io.github.benas.randombeans.annotation.Priority;
import io.github.benas.randombeans.api.EnhancedRandomParameters;
import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.api.RandomizerRegistry;
import io.github.benas.randombeans.randomizers.registry.AbstractRandomizerRegistry;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

@Priority(value=-1)
public class CustomRandomizerRegistry
extends AbstractRandomizerRegistry
implements RandomizerRegistry {
    private final Map<FieldDefinition<?, ?>, Randomizer<?>> customFieldRandomizersRegistry = new HashMap();
    private final Map<Class<?>, Randomizer<?>> customTypeRandomizersRegistry = new HashMap();

    @Override
    public void init(EnhancedRandomParameters parameters) {
    }

    @Override
    public Randomizer<?> getRandomizer(Field field) {
        for (FieldDefinition<?, ?> fieldDefinition : this.customFieldRandomizersRegistry.keySet()) {
            if (!this.hasName(field, fieldDefinition.getName()) || !this.isDeclaredInClass(field, fieldDefinition.getClazz()) || !this.hasType(field, fieldDefinition.getType()) || !this.isAnnotatedWithOneOf(field, fieldDefinition.getAnnotations())) continue;
            return this.customFieldRandomizersRegistry.get(fieldDefinition);
        }
        return this.customTypeRandomizersRegistry.get(field.getType());
    }

    @Override
    public Randomizer<?> getRandomizer(Class<?> type) {
        return this.customTypeRandomizersRegistry.get(type);
    }

    public <T, F, R> void registerRandomizer(FieldDefinition<T, F> fieldDefinition, Randomizer<R> randomizer) {
        this.customFieldRandomizersRegistry.put(fieldDefinition, randomizer);
    }

    public <T, R> void registerRandomizer(Class<T> type, Randomizer<R> randomizer) {
        this.customTypeRandomizersRegistry.put(type, randomizer);
    }
}

