/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.time;

import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.randomizers.misc.EnumRandomizer;
import io.github.benas.randombeans.randomizers.time.YearRandomizer;
import io.github.benas.randombeans.randomizers.time.internal.DayRandomizer;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;

public class LocalDateRandomizer
implements Randomizer<LocalDate> {
    private final YearRandomizer yearRandomizer;
    private final EnumRandomizer<Month> monthRandomizer;
    private final DayRandomizer dayRandomizer;

    public LocalDateRandomizer() {
        this.yearRandomizer = new YearRandomizer();
        this.monthRandomizer = new EnumRandomizer<Month>(Month.class);
        this.dayRandomizer = new DayRandomizer();
    }

    public LocalDateRandomizer(long seed) {
        this.yearRandomizer = new YearRandomizer(seed);
        this.monthRandomizer = new EnumRandomizer<Month>(Month.class, seed);
        this.dayRandomizer = new DayRandomizer(seed);
    }

    public static LocalDateRandomizer aNewLocalDateRandomizer() {
        return new LocalDateRandomizer();
    }

    public static LocalDateRandomizer aNewLocalDateRandomizer(long seed) {
        return new LocalDateRandomizer(seed);
    }

    @Override
    public LocalDate getRandomValue() {
        Year randomYear = this.yearRandomizer.getRandomValue();
        Month randomMonth = (Month)this.monthRandomizer.getRandomValue();
        int randomDay = this.dayRandomizer.getRandomValue();
        return LocalDate.of(randomYear.getValue(), randomMonth.getValue(), randomDay);
    }
}

