/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.api;

import io.github.benas.randombeans.EnhancedRandomBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class EnhancedRandom
extends Random {
    public static <T> T random(Class<T> type, String ... excludedFields) {
        return EnhancedRandomBuilder.aNewEnhancedRandomBuilder().build().nextObject(type, excludedFields);
    }

    public static <T> Stream<T> randomStreamOf(int amount, Class<T> type, String ... excludedFields) {
        return EnhancedRandomBuilder.aNewEnhancedRandomBuilder().build().objects(type, amount, excludedFields);
    }

    public static <T> List<T> randomListOf(int amount, Class<T> type, String ... excludedFields) {
        return EnhancedRandom.randomStreamOf(amount, type, excludedFields).collect(Collectors.toList());
    }

    public static <T> Set<T> randomSetOf(int amount, Class<T> type, String ... excludedFields) {
        return EnhancedRandom.randomStreamOf(amount, type, excludedFields).collect(Collectors.toSet());
    }

    public static <T> Collection<T> randomCollectionOf(int amount, Class<T> type, String ... excludedFields) {
        return EnhancedRandom.randomListOf(amount, type, excludedFields);
    }

    public abstract <T> T nextObject(Class<T> var1, String ... var2);

    public abstract <T> Stream<T> objects(Class<T> var1, int var2, String ... var3);
}

