/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.benas.randombeans.annotation.RandomizerArgument;
import io.github.benas.randombeans.api.ObjectGenerationException;
import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.util.FastClasspathScannerFacade;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ReflectionUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static <T> List<Field> getDeclaredFields(T type) {
        return new ArrayList<Field>(Arrays.asList(type.getClass().getDeclaredFields()));
    }

    public static List<Field> getInheritedFields(Class<?> type) {
        ArrayList<Field> inheritedFields = new ArrayList<Field>();
        while (type.getSuperclass() != null) {
            Class<?> superclass = type.getSuperclass();
            inheritedFields.addAll(Arrays.asList(superclass.getDeclaredFields()));
            type = superclass;
        }
        return inheritedFields;
    }

    public static void setProperty(Object object, Field field, Object value) throws IllegalAccessException {
        boolean access = field.isAccessible();
        field.setAccessible(true);
        field.set(object, value);
        field.setAccessible(access);
    }

    public static boolean isStatic(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }

    public static boolean isInterface(Class<?> type) {
        return type.isInterface();
    }

    public static <T> boolean isAbstract(Class<T> type) {
        return Modifier.isAbstract(type.getModifiers());
    }

    public static <T> boolean isPublic(Class<T> type) {
        return Modifier.isPublic(type.getModifiers());
    }

    public static boolean isArrayType(Class<?> type) {
        return type.isArray();
    }

    public static boolean isEnumType(Class<?> type) {
        return type.isEnum();
    }

    public static boolean isCollectionType(Class<?> type) {
        return Collection.class.isAssignableFrom(type);
    }

    public static boolean isCollectionType(Type type) {
        return ReflectionUtils.isParameterizedType(type) && ReflectionUtils.isCollectionType((Class)((ParameterizedType)type).getRawType());
    }

    public static boolean isPopulatable(Type type) {
        return !ReflectionUtils.isWildcardType(type) && !ReflectionUtils.isCollectionType(type);
    }

    public static boolean isIntrospectable(Class<?> type) {
        return !(ReflectionUtils.isEnumType(type) || ReflectionUtils.isArrayType(type) || ReflectionUtils.isCollectionType(type) && ReflectionUtils.isJdkBuiltIn(type) || ReflectionUtils.isMapType(type) && ReflectionUtils.isJdkBuiltIn(type));
    }

    public static boolean isMapType(Class<?> type) {
        return Map.class.isAssignableFrom(type);
    }

    public static boolean isJdkBuiltIn(Class<?> type) {
        return type.getName().startsWith("java.util");
    }

    public static boolean isParameterizedType(Type type) {
        return type != null && type instanceof ParameterizedType && ((ParameterizedType)type).getActualTypeArguments().length > 0;
    }

    public static boolean isWildcardType(Type type) {
        return type instanceof WildcardType;
    }

    public static <T> List<Class<?>> getPublicConcreteSubTypesOf(Class<T> type) {
        return FastClasspathScannerFacade.getPublicConcreteSubTypesOf(type);
    }

    public static List<Class<?>> filterSameParameterizedTypes(List<Class<?>> types, Type type) {
        if (type instanceof ParameterizedType) {
            Type[] fieldArugmentTypes = ((ParameterizedType)type).getActualTypeArguments();
            ArrayList typesWithSameParameterizedTypes = new ArrayList();
            for (Class<?> currentConcreteType : types) {
                List<Type[]> actualTypeArguments = ReflectionUtils.getActualTypeArgumentsOfGenericInterfaces(currentConcreteType);
                typesWithSameParameterizedTypes.addAll(actualTypeArguments.stream().filter(currentTypeArguments -> Arrays.equals(fieldArugmentTypes, currentTypeArguments)).map(currentTypeArguments -> currentConcreteType).collect(Collectors.toList()));
            }
            return typesWithSameParameterizedTypes;
        }
        return types;
    }

    private static List<Type[]> getActualTypeArgumentsOfGenericInterfaces(Class<?> type) {
        Type[] genericInterfaceTypes;
        ArrayList<Type[]> actualTypeArguments = new ArrayList<Type[]>();
        for (Type currentGenericInterfaceType : genericInterfaceTypes = type.getGenericInterfaces()) {
            if (!(currentGenericInterfaceType instanceof ParameterizedType)) continue;
            actualTypeArguments.add(((ParameterizedType)currentGenericInterfaceType).getActualTypeArguments());
        }
        return actualTypeArguments;
    }

    public static <T> Randomizer<T> newInstance(Class<T> type, RandomizerArgument[] randomizerArguments) {
        try {
            Optional<Constructor> matchingConstructor;
            if (ReflectionUtils.notEmpty(randomizerArguments) && (matchingConstructor = Arrays.asList(type.getConstructors()).stream().filter(constructor -> ReflectionUtils.hasSameArgumentNumber(constructor, randomizerArguments) && ReflectionUtils.hasSameArgumentTypes(constructor, randomizerArguments)).findFirst()).isPresent()) {
                return (Randomizer)matchingConstructor.get().newInstance(ReflectionUtils.convertArguments(randomizerArguments));
            }
            return (Randomizer)type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ObjectGenerationException(String.format("Could not create Randomizer of type: %s with constructor arguments: %s", type, Arrays.toString(randomizerArguments)), e);
        }
    }

    private static boolean notEmpty(RandomizerArgument[] randomizerArguments) {
        return randomizerArguments != null && randomizerArguments.length > 0;
    }

    private static boolean hasSameArgumentNumber(Constructor<?> constructor, RandomizerArgument[] randomizerArguments) {
        return constructor.getParameterCount() == randomizerArguments.length;
    }

    private static boolean hasSameArgumentTypes(Constructor<?> constructor, RandomizerArgument[] randomizerArguments) {
        Class<?>[] constructorParameterTypes = constructor.getParameterTypes();
        for (int i = 0; i < randomizerArguments.length; ++i) {
            if (constructorParameterTypes[i].isAssignableFrom(randomizerArguments[i].type())) continue;
            return false;
        }
        return true;
    }

    private static Object[] convertArguments(RandomizerArgument[] declaredArguments) {
        int numberOfArguments = declaredArguments.length;
        Object[] arguments = new Object[numberOfArguments];
        for (int i = 0; i < numberOfArguments; ++i) {
            arguments[i] = objectMapper.convertValue((Object)declaredArguments[i].value(), declaredArguments[i].type());
        }
        return arguments;
    }

    private ReflectionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

