/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.registry;

import io.github.benas.randombeans.FieldDefinition;
import io.github.benas.randombeans.annotation.Priority;
import io.github.benas.randombeans.api.EnhancedRandomParameters;
import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.api.RandomizerRegistry;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

@Priority(value=0)
public class CustomRandomizerRegistry
implements RandomizerRegistry {
    private final Map<FieldDefinition<?, ?>, Randomizer<?>> customFieldRandomizersRegistry = new HashMap();
    private final Map<Class<?>, Randomizer<?>> customTypeRandomizersRegistry = new HashMap();

    @Override
    public void init(EnhancedRandomParameters parameters) {
    }

    @Override
    public void setSeed(long seed) {
    }

    @Override
    public Randomizer<?> getRandomizer(Field field) {
        Class<?> type = field.getType();
        Randomizer<?> randomizer = this.customFieldRandomizersRegistry.get(new FieldDefinition(field.getName(), type, field.getDeclaringClass()));
        return randomizer != null ? randomizer : this.customTypeRandomizersRegistry.get(type);
    }

    @Override
    public Randomizer<?> getRandomizer(Class<?> type) {
        return this.customTypeRandomizersRegistry.get(type);
    }

    public <T, F, R> void registerRandomizer(FieldDefinition<T, F> fieldDefinition, Randomizer<R> randomizer) {
        this.customFieldRandomizersRegistry.put(fieldDefinition, randomizer);
    }

    public <T, R> void registerRandomizer(Class<T> type, Randomizer<R> randomizer) {
        this.customTypeRandomizersRegistry.put(type, randomizer);
    }
}

