/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.registry;

import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.api.RandomizerRegistry;
import io.github.benas.randombeans.randomizers.time.DurationRandomizer;
import io.github.benas.randombeans.randomizers.time.GregorianCalendarRandomizer;
import io.github.benas.randombeans.randomizers.time.InstantRandomizer;
import io.github.benas.randombeans.randomizers.time.LocalDateRandomizer;
import io.github.benas.randombeans.randomizers.time.LocalDateTimeRandomizer;
import io.github.benas.randombeans.randomizers.time.LocalTimeRandomizer;
import io.github.benas.randombeans.randomizers.time.MonthDayRandomizer;
import io.github.benas.randombeans.randomizers.time.OffsetDateTimeRandomizer;
import io.github.benas.randombeans.randomizers.time.OffsetTimeRandomizer;
import io.github.benas.randombeans.randomizers.time.PeriodRandomizer;
import io.github.benas.randombeans.randomizers.time.TimeZoneRandomizer;
import io.github.benas.randombeans.randomizers.time.YearMonthRandomizer;
import io.github.benas.randombeans.randomizers.time.YearRandomizer;
import io.github.benas.randombeans.randomizers.time.ZoneOffsetRandomizer;
import io.github.benas.randombeans.randomizers.time.ZonedDateTimeRandomizer;
import java.lang.reflect.Field;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class TimeRandomizerRegistry
implements RandomizerRegistry {
    private final Map<Class<?>, Randomizer<?>> randomizers = new HashMap();

    @Override
    public void setSeed(long seed) {
        this.randomizers.put(Duration.class, new DurationRandomizer(seed));
        this.randomizers.put(GregorianCalendar.class, new GregorianCalendarRandomizer(seed));
        this.randomizers.put(Instant.class, new InstantRandomizer(seed));
        this.randomizers.put(LocalDate.class, new LocalDateRandomizer(seed));
        this.randomizers.put(LocalDateTime.class, new LocalDateTimeRandomizer(seed));
        this.randomizers.put(LocalTime.class, new LocalTimeRandomizer(seed));
        this.randomizers.put(MonthDay.class, new MonthDayRandomizer(seed));
        this.randomizers.put(OffsetDateTime.class, new OffsetDateTimeRandomizer(seed));
        this.randomizers.put(OffsetTime.class, new OffsetTimeRandomizer(seed));
        this.randomizers.put(Period.class, new PeriodRandomizer(seed));
        this.randomizers.put(TimeZone.class, new TimeZoneRandomizer(seed));
        this.randomizers.put(YearMonth.class, new YearMonthRandomizer(seed));
        this.randomizers.put(Year.class, new YearRandomizer(seed));
        this.randomizers.put(ZonedDateTime.class, new ZonedDateTimeRandomizer(seed));
        this.randomizers.put(ZoneOffset.class, new ZoneOffsetRandomizer(seed));
    }

    @Override
    public Randomizer<?> getRandomizer(Field field) {
        return this.getRandomizer(field.getType());
    }

    @Override
    public Randomizer<?> getRandomizer(Class<?> type) {
        return this.randomizers.get(type);
    }
}

