/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.registry;

import io.github.benas.randombeans.annotation.Priority;
import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.api.RandomizerRegistry;
import io.github.benas.randombeans.randomizers.AtomicIntegerRandomizer;
import io.github.benas.randombeans.randomizers.AtomicLongRandomizer;
import io.github.benas.randombeans.randomizers.BigDecimalRandomizer;
import io.github.benas.randombeans.randomizers.BigIntegerRandomizer;
import io.github.benas.randombeans.randomizers.BooleanRandomizer;
import io.github.benas.randombeans.randomizers.ByteRandomizer;
import io.github.benas.randombeans.randomizers.CalendarRandomizer;
import io.github.benas.randombeans.randomizers.CharacterRandomizer;
import io.github.benas.randombeans.randomizers.DateRandomizer;
import io.github.benas.randombeans.randomizers.DoubleRandomizer;
import io.github.benas.randombeans.randomizers.FloatRandomizer;
import io.github.benas.randombeans.randomizers.IntegerRandomizer;
import io.github.benas.randombeans.randomizers.LongRandomizer;
import io.github.benas.randombeans.randomizers.ShortRandomizer;
import io.github.benas.randombeans.randomizers.SqlDateRandomizer;
import io.github.benas.randombeans.randomizers.SqlTimeRandomizer;
import io.github.benas.randombeans.randomizers.SqlTimestampRandomizer;
import io.github.benas.randombeans.randomizers.StringRandomizer;
import io.github.benas.randombeans.randomizers.UriRandomizer;
import io.github.benas.randombeans.randomizers.UrlRandomizer;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

@Priority(value=-255)
public class InternalRandomizerRegistry
implements RandomizerRegistry {
    private final Map<Class<?>, Randomizer<?>> randomizers = new HashMap();

    @Override
    public void setSeed(long seed) {
        this.randomizers.put(String.class, new StringRandomizer(seed));
        this.randomizers.put(Character.class, new CharacterRandomizer(seed));
        this.randomizers.put(Character.TYPE, new CharacterRandomizer(seed));
        this.randomizers.put(Boolean.class, new BooleanRandomizer(seed));
        this.randomizers.put(Boolean.TYPE, new BooleanRandomizer(seed));
        this.randomizers.put(Byte.class, new ByteRandomizer(seed));
        this.randomizers.put(Byte.TYPE, new ByteRandomizer(seed));
        this.randomizers.put(Short.class, new ShortRandomizer(seed));
        this.randomizers.put(Short.TYPE, new ShortRandomizer(seed));
        this.randomizers.put(Integer.class, new IntegerRandomizer(seed));
        this.randomizers.put(Integer.TYPE, new IntegerRandomizer(seed));
        this.randomizers.put(Long.class, new LongRandomizer(seed));
        this.randomizers.put(Long.TYPE, new LongRandomizer(seed));
        this.randomizers.put(Double.class, new DoubleRandomizer(seed));
        this.randomizers.put(Double.TYPE, new DoubleRandomizer(seed));
        this.randomizers.put(Float.class, new FloatRandomizer(seed));
        this.randomizers.put(Float.TYPE, new FloatRandomizer(seed));
        this.randomizers.put(BigInteger.class, new BigIntegerRandomizer(seed));
        this.randomizers.put(BigDecimal.class, new BigDecimalRandomizer(seed));
        this.randomizers.put(AtomicLong.class, new AtomicLongRandomizer(seed));
        this.randomizers.put(AtomicInteger.class, new AtomicIntegerRandomizer(seed));
        this.randomizers.put(java.util.Date.class, new DateRandomizer(seed));
        this.randomizers.put(Date.class, new SqlDateRandomizer(seed));
        this.randomizers.put(Time.class, new SqlTimeRandomizer(seed));
        this.randomizers.put(Timestamp.class, new SqlTimestampRandomizer(seed));
        this.randomizers.put(Calendar.class, new CalendarRandomizer(seed));
        this.randomizers.put(URL.class, new UrlRandomizer(seed));
        this.randomizers.put(URI.class, new UriRandomizer(seed));
    }

    @Override
    public Randomizer<?> getRandomizer(Field field) {
        return this.getRandomizer(field.getType());
    }

    @Override
    public Randomizer<?> getRandomizer(Class<?> type) {
        return this.randomizers.get(type);
    }
}

