/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.range;

import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.randomizers.StringRandomizer;
import io.github.benas.randombeans.randomizers.range.IntegerRangeRandomizer;

public class StringLengthRandomizer
implements Randomizer<String> {
    private StringRandomizer stringRandomizer;
    private IntegerRangeRandomizer integerRangeRandomizer;

    public StringLengthRandomizer(Integer min, Integer max) {
        this.stringRandomizer = new StringRandomizer();
        this.integerRangeRandomizer = new IntegerRangeRandomizer(min == null || min < 0 ? 0 : min, max);
    }

    public StringLengthRandomizer(Integer min, Integer max, long seed) {
        this.stringRandomizer = new StringRandomizer(seed);
        this.integerRangeRandomizer = new IntegerRangeRandomizer(min == null || min < 0 ? 0 : min, max, seed);
    }

    public static StringLengthRandomizer aNewStringLengthRandomizer(Integer min, Integer max) {
        return new StringLengthRandomizer(min, max);
    }

    public static StringLengthRandomizer aNewStringLengthRandomizer(Integer min, Integer max, long seed) {
        return new StringLengthRandomizer(min, max, seed);
    }

    @Override
    public String getRandomValue() {
        Integer randomLength = Math.abs(this.integerRangeRandomizer.getRandomValue());
        String randomValue = this.stringRandomizer.getRandomValue();
        if (randomValue.length() > randomLength) {
            return randomValue.substring(0, randomLength);
        }
        return randomValue;
    }
}

