/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.collection;

import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.randomizers.ByteRandomizer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class MapRandomizer<K, V>
implements Randomizer<Map<K, V>> {
    private int nbElements;
    private Randomizer<K> keyRandomizer;
    private Randomizer<V> valueRandomizer;

    public MapRandomizer(Randomizer<K> keyRandomizer, Randomizer<V> valueRandomizer) {
        this(keyRandomizer, valueRandomizer, Math.abs(ByteRandomizer.aNewByteRandomizer().getRandomValue().byteValue()));
    }

    public MapRandomizer(Randomizer<K> keyRandomizer, Randomizer<V> valueRandomizer, int nbEntries) {
        this.checkArguments(keyRandomizer, valueRandomizer, nbEntries);
        this.keyRandomizer = keyRandomizer;
        this.valueRandomizer = valueRandomizer;
        this.nbElements = nbEntries;
    }

    public static <K, V> MapRandomizer aNewMapRandomizer(Randomizer<K> keyRandomizer, Randomizer<V> valueRandomizer) {
        return new MapRandomizer<K, V>(keyRandomizer, valueRandomizer, Math.abs(ByteRandomizer.aNewByteRandomizer().getRandomValue().byteValue()));
    }

    public static <K, V> MapRandomizer aNewMapRandomizer(Randomizer<K> keyRandomizer, Randomizer<V> valueRandomizer, int nbEntries) {
        return new MapRandomizer<K, V>(keyRandomizer, valueRandomizer, nbEntries);
    }

    @Override
    public Map<K, V> getRandomValue() {
        HashMap<K, V> result = new HashMap<K, V>();
        for (int i = 0; i < this.nbElements; ++i) {
            result.put(this.keyRandomizer.getRandomValue(), this.valueRandomizer.getRandomValue());
        }
        return result;
    }

    private void checkArguments(Randomizer<K> keyRandomizer, Randomizer<V> valueRandomizer, int nbEntries) {
        Objects.requireNonNull(keyRandomizer, "The randomizer of keys must not be null");
        Objects.requireNonNull(valueRandomizer, "The randomizer of values must not be null");
        if (nbEntries < 1) {
            throw new IllegalArgumentException("The number of entries to generate must be >= 1");
        }
    }
}

