/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.collection;

import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.randomizers.ByteRandomizer;
import java.util.Collection;
import java.util.Objects;

public abstract class CollectionRandomizer<T>
implements Randomizer<Collection<T>> {
    protected int nbElements;
    protected Randomizer<T> delegate;

    protected CollectionRandomizer(Randomizer<T> delegate) {
        this(delegate, Math.abs(ByteRandomizer.aNewByteRandomizer().getRandomValue().byteValue()));
    }

    protected CollectionRandomizer(Randomizer<T> delegate, int nbElements) {
        this.checkArguments(delegate, nbElements);
        this.nbElements = nbElements;
        this.delegate = delegate;
    }

    protected void checkArguments(Randomizer<T> delegate, int nbElements) {
        Objects.requireNonNull(delegate, "The delegate randomizer must not be null");
        if (nbElements < 1) {
            throw new IllegalArgumentException("The number of elements to generate must be >= 1");
        }
    }

    protected T getRandomElement() {
        return this.delegate.getRandomValue();
    }
}

