/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers;

import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.randomizers.AbstractRandomizer;

public class OptionalRandomizer<T>
extends AbstractRandomizer<T> {
    private static final int MAX_PERCENT = 100;
    private Randomizer<T> delegate;
    private int optionalPercent;

    public OptionalRandomizer(Randomizer<T> delegate, int optionalPercent) {
        this.delegate = delegate;
        this.optionalPercent = optionalPercent > 100 ? 100 : (optionalPercent < 0 ? 0 : optionalPercent);
    }

    public static <T> Randomizer<T> aNewOptionalRandomizer(Randomizer<T> delegate, int optionalPercent) {
        return new OptionalRandomizer<T>(delegate, optionalPercent);
    }

    @Override
    public T getRandomValue() {
        Integer randomPercent = this.random.nextInt(100);
        if (randomPercent <= this.optionalPercent) {
            return this.delegate.getRandomValue();
        }
        return null;
    }
}

