/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans;

import io.github.benas.randombeans.EnhancedRandomImpl;
import io.github.benas.randombeans.ObjectFactory;
import io.github.benas.randombeans.PopulatorContext;
import io.github.benas.randombeans.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TransferQueue;

class CollectionPopulator {
    private EnhancedRandomImpl enhancedRandom;
    private ObjectFactory objectFactory;

    CollectionPopulator(EnhancedRandomImpl enhancedRandom, ObjectFactory objectFactory) {
        this.enhancedRandom = enhancedRandom;
        this.objectFactory = objectFactory;
    }

    Collection<?> getRandomCollection(Field field, PopulatorContext context) {
        ParameterizedType parameterizedType;
        Type type;
        int randomSize = this.enhancedRandom.nextInt(127);
        Class<?> fieldType = field.getType();
        Type fieldGenericType = field.getGenericType();
        Collection<?> collection = ReflectionUtils.isInterface(fieldType) ? this.getEmptyImplementationForCollectionInterface(fieldType) : this.objectFactory.createEmptyCollectionForType(fieldType, randomSize);
        if (ReflectionUtils.isParameterizedType(fieldGenericType) && ReflectionUtils.isPopulatable(type = (parameterizedType = (ParameterizedType)fieldGenericType).getActualTypeArguments()[0])) {
            for (int i = 0; i < randomSize; ++i) {
                Object item = this.enhancedRandom.doPopulateBean((Class)type, context);
                collection.add(item);
            }
        }
        return collection;
    }

    Collection<?> getEmptyImplementationForCollectionInterface(Class<?> collectionInterface) {
        AbstractCollection collection = new ArrayList();
        if (List.class.isAssignableFrom(collectionInterface)) {
            collection = new ArrayList();
        } else if (NavigableSet.class.isAssignableFrom(collectionInterface)) {
            collection = new TreeSet();
        } else if (SortedSet.class.isAssignableFrom(collectionInterface)) {
            collection = new TreeSet();
        } else if (Set.class.isAssignableFrom(collectionInterface)) {
            collection = new HashSet();
        } else if (BlockingDeque.class.isAssignableFrom(collectionInterface)) {
            collection = new LinkedBlockingDeque();
        } else if (Deque.class.isAssignableFrom(collectionInterface)) {
            collection = new ArrayDeque();
        } else if (TransferQueue.class.isAssignableFrom(collectionInterface)) {
            collection = new LinkedTransferQueue();
        } else if (BlockingQueue.class.isAssignableFrom(collectionInterface)) {
            collection = new LinkedBlockingQueue();
        } else if (Queue.class.isAssignableFrom(collectionInterface)) {
            collection = new LinkedList();
        }
        return collection;
    }
}

