/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans;

import io.github.benas.randombeans.EnhancedRandomImpl;
import io.github.benas.randombeans.PopulatorContext;
import java.lang.reflect.Array;

class ArrayPopulator {
    private EnhancedRandomImpl enhancedRandom;

    ArrayPopulator(EnhancedRandomImpl enhancedRandom) {
        this.enhancedRandom = enhancedRandom;
    }

    <T> Object getRandomArray(Class<?> fieldType, PopulatorContext context) {
        Class<?> componentType = fieldType.getComponentType();
        if (componentType.isPrimitive()) {
            return this.getRandomPrimitiveArray(componentType);
        }
        int randomSize = Math.abs((byte)this.enhancedRandom.nextInt());
        Object[] itemsList = (Object[])Array.newInstance(componentType, randomSize);
        for (int i = 0; i < randomSize; ++i) {
            itemsList[i] = this.enhancedRandom.doPopulateBean(fieldType.getComponentType(), context);
        }
        return itemsList;
    }

    Object getRandomPrimitiveArray(Class<?> primitiveType) {
        int randomSize = Math.abs((byte)this.enhancedRandom.nextInt());
        if (primitiveType.equals(Byte.TYPE)) {
            byte[] result = new byte[randomSize];
            for (int index = 0; index < randomSize; ++index) {
                result[index] = (byte)this.enhancedRandom.nextInt();
            }
            return result;
        }
        if (primitiveType.equals(Short.TYPE)) {
            short[] result = new short[randomSize];
            for (int index = 0; index < randomSize; ++index) {
                result[index] = (short)this.enhancedRandom.nextInt();
            }
            return result;
        }
        if (primitiveType.equals(Integer.TYPE)) {
            int[] result = new int[randomSize];
            for (int index = 0; index < randomSize; ++index) {
                result[index] = this.enhancedRandom.nextInt();
            }
            return result;
        }
        if (primitiveType.equals(Long.TYPE)) {
            long[] result = new long[randomSize];
            for (int index = 0; index < randomSize; ++index) {
                result[index] = this.enhancedRandom.nextLong();
            }
            return result;
        }
        if (primitiveType.equals(Float.TYPE)) {
            float[] result = new float[randomSize];
            for (int index = 0; index < randomSize; ++index) {
                result[index] = this.enhancedRandom.nextFloat();
            }
            return result;
        }
        if (primitiveType.equals(Double.TYPE)) {
            double[] result = new double[randomSize];
            for (int index = 0; index < randomSize; ++index) {
                result[index] = this.enhancedRandom.nextDouble();
            }
            return result;
        }
        if (primitiveType.equals(Character.TYPE)) {
            char[] result = new char[randomSize];
            for (int index = 0; index < randomSize; ++index) {
                result[index] = (char)this.enhancedRandom.nextInt();
            }
            return result;
        }
        if (primitiveType.equals(Boolean.TYPE)) {
            boolean[] result = new boolean[randomSize];
            for (int index = 0; index < randomSize; ++index) {
                result[index] = this.enhancedRandom.nextBoolean();
            }
            return result;
        }
        return null;
    }
}

