/*
 * Decompiled with CFR 0.152.
 */
package com.azhon.appupdate.manager;

import android.app.Activity;
import android.app.Application;
import android.app.NotificationChannel;
import android.content.Context;
import android.content.Intent;
import android.widget.Toast;
import com.azhon.appupdate.R;
import com.azhon.appupdate.base.BaseHttpDownloadManager;
import com.azhon.appupdate.config.Constant;
import com.azhon.appupdate.listener.LifecycleCallbacksAdapter;
import com.azhon.appupdate.listener.OnButtonClickListener;
import com.azhon.appupdate.listener.OnDownloadListener;
import com.azhon.appupdate.service.DownloadService;
import com.azhon.appupdate.util.ApkUtil;
import com.azhon.appupdate.util.LogUtil;
import com.azhon.appupdate.view.UpdateDialogActivity;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000 m2\u00020\u0001:\u0002lmB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010d\u001a\u00020eJ\b\u0010f\u001a\u000203H\u0002J\b\u0010g\u001a\u000203H\u0002J\b\u0010h\u001a\u00020eH\u0002J\u0006\u0010i\u001a\u00020eJ\r\u0010j\u001a\u00020eH\u0000\u00a2\u0006\u0002\bkR\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR\u001a\u0010\u0011\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\nR\u001a\u0010\u0014\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\b\"\u0004\b\u0016\u0010\nR\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\b\"\u0004\b\u001b\u0010\nR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\b\"\u0004\b \u0010\nR\u001a\u0010!\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%R\u001a\u0010)\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010#\"\u0004\b+\u0010%R\u001a\u0010,\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010#\"\u0004\b.\u0010%R\u001a\u0010/\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\b\"\u0004\b1\u0010\nR\u001a\u00102\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u000203X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u00105\"\u0004\b:\u00107R\u001c\u0010;\u001a\u0004\u0018\u00010<X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u001a\u0010A\u001a\u000203X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u00105\"\u0004\bC\u00107R\u001c\u0010D\u001a\u0004\u0018\u00010EX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u001a\u0010J\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010#\"\u0004\bL\u0010%R\u001c\u0010M\u001a\u0004\u0018\u00010NX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR \u0010S\u001a\b\u0012\u0004\u0012\u00020U0TX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010W\"\u0004\bX\u0010YR\u001a\u0010Z\u001a\u000203X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u00105\"\u0004\b\\\u00107R\u000e\u0010]\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010^\u001a\u000203X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u00105\"\u0004\b`\u00107R\u001a\u0010a\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010#\"\u0004\bc\u0010%\u00a8\u0006n"}, d2={"Lcom/azhon/appupdate/manager/DownloadManager;", "Ljava/io/Serializable;", "builder", "Lcom/azhon/appupdate/manager/DownloadManager$Builder;", "(Lcom/azhon/appupdate/manager/DownloadManager$Builder;)V", "apkDescription", "", "getApkDescription$appupdate_release", "()Ljava/lang/String;", "setApkDescription$appupdate_release", "(Ljava/lang/String;)V", "apkMD5", "getApkMD5$appupdate_release", "setApkMD5$appupdate_release", "apkName", "getApkName$appupdate_release", "setApkName$appupdate_release", "apkSize", "getApkSize$appupdate_release", "setApkSize$appupdate_release", "apkUrl", "getApkUrl$appupdate_release", "setApkUrl$appupdate_release", "apkVersionCode", "", "apkVersionName", "getApkVersionName$appupdate_release", "setApkVersionName$appupdate_release", "application", "Landroid/app/Application;", "contextClsName", "getContextClsName$appupdate_release", "setContextClsName$appupdate_release", "dialogButtonColor", "getDialogButtonColor$appupdate_release", "()I", "setDialogButtonColor$appupdate_release", "(I)V", "dialogButtonTextColor", "getDialogButtonTextColor$appupdate_release", "setDialogButtonTextColor$appupdate_release", "dialogImage", "getDialogImage$appupdate_release", "setDialogImage$appupdate_release", "dialogProgressBarColor", "getDialogProgressBarColor$appupdate_release", "setDialogProgressBarColor$appupdate_release", "downloadPath", "getDownloadPath$appupdate_release", "setDownloadPath$appupdate_release", "downloadState", "", "getDownloadState", "()Z", "setDownloadState", "(Z)V", "forcedUpgrade", "getForcedUpgrade$appupdate_release", "setForcedUpgrade$appupdate_release", "httpManager", "Lcom/azhon/appupdate/base/BaseHttpDownloadManager;", "getHttpManager$appupdate_release", "()Lcom/azhon/appupdate/base/BaseHttpDownloadManager;", "setHttpManager$appupdate_release", "(Lcom/azhon/appupdate/base/BaseHttpDownloadManager;)V", "jumpInstallPage", "getJumpInstallPage$appupdate_release", "setJumpInstallPage$appupdate_release", "notificationChannel", "Landroid/app/NotificationChannel;", "getNotificationChannel$appupdate_release", "()Landroid/app/NotificationChannel;", "setNotificationChannel$appupdate_release", "(Landroid/app/NotificationChannel;)V", "notifyId", "getNotifyId$appupdate_release", "setNotifyId$appupdate_release", "onButtonClickListener", "Lcom/azhon/appupdate/listener/OnButtonClickListener;", "getOnButtonClickListener$appupdate_release", "()Lcom/azhon/appupdate/listener/OnButtonClickListener;", "setOnButtonClickListener$appupdate_release", "(Lcom/azhon/appupdate/listener/OnButtonClickListener;)V", "onDownloadListeners", "", "Lcom/azhon/appupdate/listener/OnDownloadListener;", "getOnDownloadListeners$appupdate_release", "()Ljava/util/List;", "setOnDownloadListeners$appupdate_release", "(Ljava/util/List;)V", "showBgdToast", "getShowBgdToast$appupdate_release", "setShowBgdToast$appupdate_release", "showNewerToast", "showNotification", "getShowNotification$appupdate_release", "setShowNotification$appupdate_release", "smallIcon", "getSmallIcon$appupdate_release", "setSmallIcon$appupdate_release", "cancel", "", "checkParams", "checkVersionCode", "clearListener", "download", "release", "release$appupdate_release", "Builder", "Companion", "appupdate_release"})
public final class DownloadManager
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Application application;
    private int apkVersionCode;
    private boolean showNewerToast;
    @NotNull
    private String contextClsName;
    @NotNull
    private String apkUrl;
    @NotNull
    private String apkName;
    @NotNull
    private String apkVersionName;
    @NotNull
    private String downloadPath;
    private int smallIcon;
    @NotNull
    private String apkDescription;
    @NotNull
    private String apkSize;
    @NotNull
    private String apkMD5;
    @Nullable
    private BaseHttpDownloadManager httpManager;
    @Nullable
    private NotificationChannel notificationChannel;
    @NotNull
    private List<OnDownloadListener> onDownloadListeners;
    @Nullable
    private OnButtonClickListener onButtonClickListener;
    private boolean showNotification;
    private boolean jumpInstallPage;
    private boolean showBgdToast;
    private boolean forcedUpgrade;
    private int notifyId;
    private int dialogImage;
    private int dialogButtonColor;
    private int dialogButtonTextColor;
    private int dialogProgressBarColor;
    private boolean downloadState;
    @NotNull
    private static final String TAG = "DownloadManager";
    @Nullable
    private static DownloadManager instance;

    private DownloadManager(Builder builder) {
        this.application = builder.getApplication$appupdate_release();
        this.contextClsName = builder.getContextClsName$appupdate_release();
        this.apkUrl = builder.getApkUrl$appupdate_release();
        this.apkName = builder.getApkName$appupdate_release();
        this.apkVersionCode = builder.getApkVersionCode$appupdate_release();
        this.apkVersionName = builder.getApkVersionName$appupdate_release();
        String string = builder.getDownloadPath$appupdate_release();
        if (string == null) {
            String string2 = Constant.INSTANCE.getAPK_PATH();
            Object[] objectArray = new Object[]{this.application.getPackageName()};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        }
        this.downloadPath = string;
        this.showNewerToast = builder.getShowNewerToast$appupdate_release();
        this.smallIcon = builder.getSmallIcon$appupdate_release();
        this.apkDescription = builder.getApkDescription$appupdate_release();
        this.apkSize = builder.getApkSize$appupdate_release();
        this.apkMD5 = builder.getApkMD5$appupdate_release();
        this.httpManager = builder.getHttpManager$appupdate_release();
        this.notificationChannel = builder.getNotificationChannel$appupdate_release();
        this.onDownloadListeners = builder.getOnDownloadListeners$appupdate_release();
        this.onButtonClickListener = builder.getOnButtonClickListener$appupdate_release();
        this.showNotification = builder.getShowNotification$appupdate_release();
        this.jumpInstallPage = builder.getJumpInstallPage$appupdate_release();
        this.showBgdToast = builder.getShowBgdToast$appupdate_release();
        this.forcedUpgrade = builder.getForcedUpgrade$appupdate_release();
        this.notifyId = builder.getNotifyId$appupdate_release();
        this.dialogImage = builder.getDialogImage$appupdate_release();
        this.dialogButtonColor = builder.getDialogButtonColor$appupdate_release();
        this.dialogButtonTextColor = builder.getDialogButtonTextColor$appupdate_release();
        this.dialogProgressBarColor = builder.getDialogProgressBarColor$appupdate_release();
        this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new LifecycleCallbacksAdapter(){

            @Override
            public void onActivityDestroyed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                super.onActivityDestroyed(activity);
                if (Intrinsics.areEqual((Object)this.getContextClsName$appupdate_release(), (Object)activity.getClass().getName())) {
                    this.clearListener();
                }
            }
        });
    }

    @NotNull
    public final String getContextClsName$appupdate_release() {
        return this.contextClsName;
    }

    public final void setContextClsName$appupdate_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.contextClsName = string;
    }

    @NotNull
    public final String getApkUrl$appupdate_release() {
        return this.apkUrl;
    }

    public final void setApkUrl$appupdate_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.apkUrl = string;
    }

    @NotNull
    public final String getApkName$appupdate_release() {
        return this.apkName;
    }

    public final void setApkName$appupdate_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.apkName = string;
    }

    @NotNull
    public final String getApkVersionName$appupdate_release() {
        return this.apkVersionName;
    }

    public final void setApkVersionName$appupdate_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.apkVersionName = string;
    }

    @NotNull
    public final String getDownloadPath$appupdate_release() {
        return this.downloadPath;
    }

    public final void setDownloadPath$appupdate_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.downloadPath = string;
    }

    public final int getSmallIcon$appupdate_release() {
        return this.smallIcon;
    }

    public final void setSmallIcon$appupdate_release(int n) {
        this.smallIcon = n;
    }

    @NotNull
    public final String getApkDescription$appupdate_release() {
        return this.apkDescription;
    }

    public final void setApkDescription$appupdate_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.apkDescription = string;
    }

    @NotNull
    public final String getApkSize$appupdate_release() {
        return this.apkSize;
    }

    public final void setApkSize$appupdate_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.apkSize = string;
    }

    @NotNull
    public final String getApkMD5$appupdate_release() {
        return this.apkMD5;
    }

    public final void setApkMD5$appupdate_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.apkMD5 = string;
    }

    @Nullable
    public final BaseHttpDownloadManager getHttpManager$appupdate_release() {
        return this.httpManager;
    }

    public final void setHttpManager$appupdate_release(@Nullable BaseHttpDownloadManager baseHttpDownloadManager) {
        this.httpManager = baseHttpDownloadManager;
    }

    @Nullable
    public final NotificationChannel getNotificationChannel$appupdate_release() {
        return this.notificationChannel;
    }

    public final void setNotificationChannel$appupdate_release(@Nullable NotificationChannel notificationChannel) {
        this.notificationChannel = notificationChannel;
    }

    @NotNull
    public final List<OnDownloadListener> getOnDownloadListeners$appupdate_release() {
        return this.onDownloadListeners;
    }

    public final void setOnDownloadListeners$appupdate_release(@NotNull List<OnDownloadListener> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.onDownloadListeners = list;
    }

    @Nullable
    public final OnButtonClickListener getOnButtonClickListener$appupdate_release() {
        return this.onButtonClickListener;
    }

    public final void setOnButtonClickListener$appupdate_release(@Nullable OnButtonClickListener onButtonClickListener) {
        this.onButtonClickListener = onButtonClickListener;
    }

    public final boolean getShowNotification$appupdate_release() {
        return this.showNotification;
    }

    public final void setShowNotification$appupdate_release(boolean bl) {
        this.showNotification = bl;
    }

    public final boolean getJumpInstallPage$appupdate_release() {
        return this.jumpInstallPage;
    }

    public final void setJumpInstallPage$appupdate_release(boolean bl) {
        this.jumpInstallPage = bl;
    }

    public final boolean getShowBgdToast$appupdate_release() {
        return this.showBgdToast;
    }

    public final void setShowBgdToast$appupdate_release(boolean bl) {
        this.showBgdToast = bl;
    }

    public final boolean getForcedUpgrade$appupdate_release() {
        return this.forcedUpgrade;
    }

    public final void setForcedUpgrade$appupdate_release(boolean bl) {
        this.forcedUpgrade = bl;
    }

    public final int getNotifyId$appupdate_release() {
        return this.notifyId;
    }

    public final void setNotifyId$appupdate_release(int n) {
        this.notifyId = n;
    }

    public final int getDialogImage$appupdate_release() {
        return this.dialogImage;
    }

    public final void setDialogImage$appupdate_release(int n) {
        this.dialogImage = n;
    }

    public final int getDialogButtonColor$appupdate_release() {
        return this.dialogButtonColor;
    }

    public final void setDialogButtonColor$appupdate_release(int n) {
        this.dialogButtonColor = n;
    }

    public final int getDialogButtonTextColor$appupdate_release() {
        return this.dialogButtonTextColor;
    }

    public final void setDialogButtonTextColor$appupdate_release(int n) {
        this.dialogButtonTextColor = n;
    }

    public final int getDialogProgressBarColor$appupdate_release() {
        return this.dialogProgressBarColor;
    }

    public final void setDialogProgressBarColor$appupdate_release(int n) {
        this.dialogProgressBarColor = n;
    }

    public final boolean getDownloadState() {
        return this.downloadState;
    }

    public final void setDownloadState(boolean bl) {
        this.downloadState = bl;
    }

    public final void download() {
        if (!this.checkParams()) {
            return;
        }
        if (this.checkVersionCode()) {
            this.application.startService(new Intent((Context)this.application, DownloadService.class));
        } else if ((long)this.apkVersionCode > ApkUtil.Companion.getVersionCode((Context)this.application)) {
            this.application.startActivity(new Intent((Context)this.application, UpdateDialogActivity.class).setFlags(0x10000000));
        } else {
            if (this.showNewerToast) {
                Toast.makeText((Context)((Context)this.application), (int)R.string.app_update_latest_version, (int)0).show();
            }
            String string2 = this.application.getResources().getString(R.string.app_update_latest_version);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"application.resources.ge\u2026pp_update_latest_version)");
            LogUtil.Companion.d(TAG, string2);
        }
    }

    private final boolean checkParams() {
        if (((CharSequence)this.apkUrl).length() == 0) {
            LogUtil.Companion.e(TAG, "apkUrl can not be empty!");
            return false;
        }
        if (((CharSequence)this.apkName).length() == 0) {
            LogUtil.Companion.e(TAG, "apkName can not be empty!");
            return false;
        }
        if (!StringsKt.endsWith$default((String)this.apkName, (String)".apk", (boolean)false, (int)2, null)) {
            LogUtil.Companion.e(TAG, "apkName must endsWith .apk!");
            return false;
        }
        if (this.smallIcon == -1) {
            LogUtil.Companion.e(TAG, "smallIcon can not be empty!");
            return false;
        }
        Constant.INSTANCE.setAUTHORITIES(this.application.getPackageName() + ".fileProvider");
        return true;
    }

    private final boolean checkVersionCode() {
        if (this.apkVersionCode == Integer.MIN_VALUE) {
            return true;
        }
        if (((CharSequence)this.apkDescription).length() == 0) {
            LogUtil.Companion.e(TAG, "apkDescription can not be empty!");
        }
        return false;
    }

    public final void cancel() {
        block0: {
            BaseHttpDownloadManager baseHttpDownloadManager = this.httpManager;
            if (baseHttpDownloadManager == null) break block0;
            baseHttpDownloadManager.cancel();
        }
    }

    public final void release$appupdate_release() {
        BaseHttpDownloadManager baseHttpDownloadManager = this.httpManager;
        if (baseHttpDownloadManager != null) {
            baseHttpDownloadManager.release();
        }
        this.clearListener();
        instance = null;
    }

    private final void clearListener() {
        this.onButtonClickListener = null;
        this.onDownloadListeners.clear();
    }

    public /* synthetic */ DownloadManager(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/azhon/appupdate/manager/DownloadManager$Companion;", "", "()V", "TAG", "", "instance", "Lcom/azhon/appupdate/manager/DownloadManager;", "getInstance", "builder", "Lcom/azhon/appupdate/manager/DownloadManager$Builder;", "getInstance$appupdate_release", "appupdate_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DownloadManager getInstance$appupdate_release(@Nullable Builder builder) {
            if (instance != null && builder != null) {
                DownloadManager downloadManager = instance;
                Intrinsics.checkNotNull((Object)downloadManager);
                downloadManager.release$appupdate_release();
            }
            if (instance == null) {
                if (builder == null) {
                    return null;
                }
                instance = new DownloadManager(builder, null);
            }
            DownloadManager downloadManager = instance;
            Intrinsics.checkNotNull((Object)downloadManager);
            return downloadManager;
        }

        public static /* synthetic */ DownloadManager getInstance$appupdate_release$default(Companion companion, Builder builder, int n, Object object) {
            if ((n & 1) != 0) {
                builder = null;
            }
            return companion.getInstance$appupdate_release(builder);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0006J\u0006\u0010i\u001a\u00020jJ\u000e\u0010)\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u0018J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0018J\u000e\u0010/\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u0018J\u000e\u00102\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0018J\u000e\u0010k\u001a\u00020\u00002\u0006\u0010l\u001a\u000209J\u000e\u00108\u001a\u00020\u00002\u0006\u00108\u001a\u000209J\u000e\u0010>\u001a\u00020\u00002\u0006\u0010>\u001a\u00020?J\u000e\u0010D\u001a\u00020\u00002\u0006\u0010D\u001a\u000209J\u000e\u0010G\u001a\u00020\u00002\u0006\u0010G\u001a\u00020HJ\u000e\u0010M\u001a\u00020\u00002\u0006\u0010M\u001a\u00020\u0018J\u000e\u0010P\u001a\u00020\u00002\u0006\u0010P\u001a\u00020QJ\u000e\u0010m\u001a\u00020\u00002\u0006\u0010m\u001a\u00020XJ\u000e\u0010]\u001a\u00020\u00002\u0006\u0010]\u001a\u000209J\u000e\u0010`\u001a\u00020\u00002\u0006\u0010`\u001a\u000209J\u000e\u0010c\u001a\u00020\u00002\u0006\u0010c\u001a\u000209J\u000e\u0010f\u001a\u00020\u00002\u0006\u0010f\u001a\u00020\u0018R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR\u001a\u0010\u0011\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\nR\u001a\u0010\u0014\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\b\"\u0004\b\u0016\u0010\nR\u001a\u0010\u0017\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\b\"\u0004\b\u001f\u0010\nR\u001a\u0010 \u001a\u00020!X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\b\"\u0004\b(\u0010\nR\u001a\u0010)\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u001a\"\u0004\b+\u0010\u001cR\u001a\u0010,\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u001a\"\u0004\b.\u0010\u001cR\u001a\u0010/\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u001a\"\u0004\b1\u0010\u001cR\u001a\u00102\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u001a\"\u0004\b4\u0010\u001cR\u001c\u00105\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\b\"\u0004\b7\u0010\nR\u001a\u00108\u001a\u000209X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001c\u0010>\u001a\u0004\u0018\u00010?X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u001a\u0010D\u001a\u000209X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010;\"\u0004\bF\u0010=R\u001c\u0010G\u001a\u0004\u0018\u00010HX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\u001a\u0010M\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010\u001a\"\u0004\bO\u0010\u001cR\u001c\u0010P\u001a\u0004\u0018\u00010QX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR \u0010V\u001a\b\u0012\u0004\u0012\u00020X0WX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\R\u001a\u0010]\u001a\u000209X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b^\u0010;\"\u0004\b_\u0010=R\u001a\u0010`\u001a\u000209X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010;\"\u0004\bb\u0010=R\u001a\u0010c\u001a\u000209X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010;\"\u0004\be\u0010=R\u001a\u0010f\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bg\u0010\u001a\"\u0004\bh\u0010\u001c\u00a8\u0006n"}, d2={"Lcom/azhon/appupdate/manager/DownloadManager$Builder;", "", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "apkDescription", "", "getApkDescription$appupdate_release", "()Ljava/lang/String;", "setApkDescription$appupdate_release", "(Ljava/lang/String;)V", "apkMD5", "getApkMD5$appupdate_release", "setApkMD5$appupdate_release", "apkName", "getApkName$appupdate_release", "setApkName$appupdate_release", "apkSize", "getApkSize$appupdate_release", "setApkSize$appupdate_release", "apkUrl", "getApkUrl$appupdate_release", "setApkUrl$appupdate_release", "apkVersionCode", "", "getApkVersionCode$appupdate_release", "()I", "setApkVersionCode$appupdate_release", "(I)V", "apkVersionName", "getApkVersionName$appupdate_release", "setApkVersionName$appupdate_release", "application", "Landroid/app/Application;", "getApplication$appupdate_release", "()Landroid/app/Application;", "setApplication$appupdate_release", "(Landroid/app/Application;)V", "contextClsName", "getContextClsName$appupdate_release", "setContextClsName$appupdate_release", "dialogButtonColor", "getDialogButtonColor$appupdate_release", "setDialogButtonColor$appupdate_release", "dialogButtonTextColor", "getDialogButtonTextColor$appupdate_release", "setDialogButtonTextColor$appupdate_release", "dialogImage", "getDialogImage$appupdate_release", "setDialogImage$appupdate_release", "dialogProgressBarColor", "getDialogProgressBarColor$appupdate_release", "setDialogProgressBarColor$appupdate_release", "downloadPath", "getDownloadPath$appupdate_release", "setDownloadPath$appupdate_release", "forcedUpgrade", "", "getForcedUpgrade$appupdate_release", "()Z", "setForcedUpgrade$appupdate_release", "(Z)V", "httpManager", "Lcom/azhon/appupdate/base/BaseHttpDownloadManager;", "getHttpManager$appupdate_release", "()Lcom/azhon/appupdate/base/BaseHttpDownloadManager;", "setHttpManager$appupdate_release", "(Lcom/azhon/appupdate/base/BaseHttpDownloadManager;)V", "jumpInstallPage", "getJumpInstallPage$appupdate_release", "setJumpInstallPage$appupdate_release", "notificationChannel", "Landroid/app/NotificationChannel;", "getNotificationChannel$appupdate_release", "()Landroid/app/NotificationChannel;", "setNotificationChannel$appupdate_release", "(Landroid/app/NotificationChannel;)V", "notifyId", "getNotifyId$appupdate_release", "setNotifyId$appupdate_release", "onButtonClickListener", "Lcom/azhon/appupdate/listener/OnButtonClickListener;", "getOnButtonClickListener$appupdate_release", "()Lcom/azhon/appupdate/listener/OnButtonClickListener;", "setOnButtonClickListener$appupdate_release", "(Lcom/azhon/appupdate/listener/OnButtonClickListener;)V", "onDownloadListeners", "", "Lcom/azhon/appupdate/listener/OnDownloadListener;", "getOnDownloadListeners$appupdate_release", "()Ljava/util/List;", "setOnDownloadListeners$appupdate_release", "(Ljava/util/List;)V", "showBgdToast", "getShowBgdToast$appupdate_release", "setShowBgdToast$appupdate_release", "showNewerToast", "getShowNewerToast$appupdate_release", "setShowNewerToast$appupdate_release", "showNotification", "getShowNotification$appupdate_release", "setShowNotification$appupdate_release", "smallIcon", "getSmallIcon$appupdate_release", "setSmallIcon$appupdate_release", "build", "Lcom/azhon/appupdate/manager/DownloadManager;", "enableLog", "enable", "onDownloadListener", "appupdate_release"})
    public static final class Builder {
        @NotNull
        private Application application;
        @NotNull
        private String contextClsName;
        @NotNull
        private String apkUrl;
        @NotNull
        private String apkName;
        private int apkVersionCode;
        @NotNull
        private String apkVersionName;
        @Nullable
        private String downloadPath;
        private boolean showNewerToast;
        private int smallIcon;
        @NotNull
        private String apkDescription;
        @NotNull
        private String apkSize;
        @NotNull
        private String apkMD5;
        @Nullable
        private BaseHttpDownloadManager httpManager;
        @Nullable
        private NotificationChannel notificationChannel;
        @NotNull
        private List<OnDownloadListener> onDownloadListeners;
        @Nullable
        private OnButtonClickListener onButtonClickListener;
        private boolean showNotification;
        private boolean jumpInstallPage;
        private boolean showBgdToast;
        private boolean forcedUpgrade;
        private int notifyId;
        private int dialogImage;
        private int dialogButtonColor;
        private int dialogButtonTextColor;
        private int dialogProgressBarColor;

        public Builder(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Application application = activity.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"activity.application");
            this.application = application;
            String string = activity.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"activity.javaClass.name");
            this.contextClsName = string;
            this.apkUrl = "";
            this.apkName = "";
            this.apkVersionCode = Integer.MIN_VALUE;
            this.apkVersionName = "";
            File file = this.application.getExternalCacheDir();
            this.downloadPath = file != null ? file.getPath() : null;
            this.smallIcon = -1;
            this.apkDescription = "";
            this.apkSize = "";
            this.apkMD5 = "";
            this.onDownloadListeners = new ArrayList();
            this.showNotification = true;
            this.jumpInstallPage = true;
            this.showBgdToast = true;
            this.notifyId = 1011;
            this.dialogImage = -1;
            this.dialogButtonColor = -1;
            this.dialogButtonTextColor = -1;
            this.dialogProgressBarColor = -1;
        }

        @NotNull
        public final Application getApplication$appupdate_release() {
            return this.application;
        }

        public final void setApplication$appupdate_release(@NotNull Application application) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"<set-?>");
            this.application = application;
        }

        @NotNull
        public final String getContextClsName$appupdate_release() {
            return this.contextClsName;
        }

        public final void setContextClsName$appupdate_release(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.contextClsName = string;
        }

        @NotNull
        public final String getApkUrl$appupdate_release() {
            return this.apkUrl;
        }

        public final void setApkUrl$appupdate_release(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.apkUrl = string;
        }

        @NotNull
        public final String getApkName$appupdate_release() {
            return this.apkName;
        }

        public final void setApkName$appupdate_release(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.apkName = string;
        }

        public final int getApkVersionCode$appupdate_release() {
            return this.apkVersionCode;
        }

        public final void setApkVersionCode$appupdate_release(int n) {
            this.apkVersionCode = n;
        }

        @NotNull
        public final String getApkVersionName$appupdate_release() {
            return this.apkVersionName;
        }

        public final void setApkVersionName$appupdate_release(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.apkVersionName = string;
        }

        @Nullable
        public final String getDownloadPath$appupdate_release() {
            return this.downloadPath;
        }

        public final void setDownloadPath$appupdate_release(@Nullable String string) {
            this.downloadPath = string;
        }

        public final boolean getShowNewerToast$appupdate_release() {
            return this.showNewerToast;
        }

        public final void setShowNewerToast$appupdate_release(boolean bl) {
            this.showNewerToast = bl;
        }

        public final int getSmallIcon$appupdate_release() {
            return this.smallIcon;
        }

        public final void setSmallIcon$appupdate_release(int n) {
            this.smallIcon = n;
        }

        @NotNull
        public final String getApkDescription$appupdate_release() {
            return this.apkDescription;
        }

        public final void setApkDescription$appupdate_release(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.apkDescription = string;
        }

        @NotNull
        public final String getApkSize$appupdate_release() {
            return this.apkSize;
        }

        public final void setApkSize$appupdate_release(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.apkSize = string;
        }

        @NotNull
        public final String getApkMD5$appupdate_release() {
            return this.apkMD5;
        }

        public final void setApkMD5$appupdate_release(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.apkMD5 = string;
        }

        @Nullable
        public final BaseHttpDownloadManager getHttpManager$appupdate_release() {
            return this.httpManager;
        }

        public final void setHttpManager$appupdate_release(@Nullable BaseHttpDownloadManager baseHttpDownloadManager) {
            this.httpManager = baseHttpDownloadManager;
        }

        @Nullable
        public final NotificationChannel getNotificationChannel$appupdate_release() {
            return this.notificationChannel;
        }

        public final void setNotificationChannel$appupdate_release(@Nullable NotificationChannel notificationChannel) {
            this.notificationChannel = notificationChannel;
        }

        @NotNull
        public final List<OnDownloadListener> getOnDownloadListeners$appupdate_release() {
            return this.onDownloadListeners;
        }

        public final void setOnDownloadListeners$appupdate_release(@NotNull List<OnDownloadListener> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.onDownloadListeners = list;
        }

        @Nullable
        public final OnButtonClickListener getOnButtonClickListener$appupdate_release() {
            return this.onButtonClickListener;
        }

        public final void setOnButtonClickListener$appupdate_release(@Nullable OnButtonClickListener onButtonClickListener) {
            this.onButtonClickListener = onButtonClickListener;
        }

        public final boolean getShowNotification$appupdate_release() {
            return this.showNotification;
        }

        public final void setShowNotification$appupdate_release(boolean bl) {
            this.showNotification = bl;
        }

        public final boolean getJumpInstallPage$appupdate_release() {
            return this.jumpInstallPage;
        }

        public final void setJumpInstallPage$appupdate_release(boolean bl) {
            this.jumpInstallPage = bl;
        }

        public final boolean getShowBgdToast$appupdate_release() {
            return this.showBgdToast;
        }

        public final void setShowBgdToast$appupdate_release(boolean bl) {
            this.showBgdToast = bl;
        }

        public final boolean getForcedUpgrade$appupdate_release() {
            return this.forcedUpgrade;
        }

        public final void setForcedUpgrade$appupdate_release(boolean bl) {
            this.forcedUpgrade = bl;
        }

        public final int getNotifyId$appupdate_release() {
            return this.notifyId;
        }

        public final void setNotifyId$appupdate_release(int n) {
            this.notifyId = n;
        }

        public final int getDialogImage$appupdate_release() {
            return this.dialogImage;
        }

        public final void setDialogImage$appupdate_release(int n) {
            this.dialogImage = n;
        }

        public final int getDialogButtonColor$appupdate_release() {
            return this.dialogButtonColor;
        }

        public final void setDialogButtonColor$appupdate_release(int n) {
            this.dialogButtonColor = n;
        }

        public final int getDialogButtonTextColor$appupdate_release() {
            return this.dialogButtonTextColor;
        }

        public final void setDialogButtonTextColor$appupdate_release(int n) {
            this.dialogButtonTextColor = n;
        }

        public final int getDialogProgressBarColor$appupdate_release() {
            return this.dialogProgressBarColor;
        }

        public final void setDialogProgressBarColor$appupdate_release(int n) {
            this.dialogProgressBarColor = n;
        }

        @NotNull
        public final Builder apkUrl(@NotNull String apkUrl) {
            Intrinsics.checkNotNullParameter((Object)apkUrl, (String)"apkUrl");
            this.apkUrl = apkUrl;
            return this;
        }

        @NotNull
        public final Builder apkName(@NotNull String apkName) {
            Intrinsics.checkNotNullParameter((Object)apkName, (String)"apkName");
            this.apkName = apkName;
            return this;
        }

        @NotNull
        public final Builder apkVersionCode(int apkVersionCode) {
            this.apkVersionCode = apkVersionCode;
            return this;
        }

        @NotNull
        public final Builder apkVersionName(@NotNull String apkVersionName) {
            Intrinsics.checkNotNullParameter((Object)apkVersionName, (String)"apkVersionName");
            this.apkVersionName = apkVersionName;
            return this;
        }

        @NotNull
        public final Builder showNewerToast(boolean showNewerToast) {
            this.showNewerToast = showNewerToast;
            return this;
        }

        @NotNull
        public final Builder smallIcon(int smallIcon) {
            this.smallIcon = smallIcon;
            return this;
        }

        @NotNull
        public final Builder apkDescription(@NotNull String apkDescription) {
            Intrinsics.checkNotNullParameter((Object)apkDescription, (String)"apkDescription");
            this.apkDescription = apkDescription;
            return this;
        }

        @NotNull
        public final Builder apkSize(@NotNull String apkSize) {
            Intrinsics.checkNotNullParameter((Object)apkSize, (String)"apkSize");
            this.apkSize = apkSize;
            return this;
        }

        @NotNull
        public final Builder apkMD5(@NotNull String apkMD5) {
            Intrinsics.checkNotNullParameter((Object)apkMD5, (String)"apkMD5");
            this.apkMD5 = apkMD5;
            return this;
        }

        @NotNull
        public final Builder httpManager(@NotNull BaseHttpDownloadManager httpManager) {
            Intrinsics.checkNotNullParameter((Object)httpManager, (String)"httpManager");
            this.httpManager = httpManager;
            return this;
        }

        @NotNull
        public final Builder notificationChannel(@NotNull NotificationChannel notificationChannel) {
            Intrinsics.checkNotNullParameter((Object)notificationChannel, (String)"notificationChannel");
            this.notificationChannel = notificationChannel;
            return this;
        }

        @NotNull
        public final Builder onButtonClickListener(@NotNull OnButtonClickListener onButtonClickListener) {
            Intrinsics.checkNotNullParameter((Object)onButtonClickListener, (String)"onButtonClickListener");
            this.onButtonClickListener = onButtonClickListener;
            return this;
        }

        @NotNull
        public final Builder onDownloadListener(@NotNull OnDownloadListener onDownloadListener) {
            Intrinsics.checkNotNullParameter((Object)onDownloadListener, (String)"onDownloadListener");
            this.onDownloadListeners.add(onDownloadListener);
            return this;
        }

        @NotNull
        public final Builder showNotification(boolean showNotification) {
            this.showNotification = showNotification;
            return this;
        }

        @NotNull
        public final Builder jumpInstallPage(boolean jumpInstallPage) {
            this.jumpInstallPage = jumpInstallPage;
            return this;
        }

        @NotNull
        public final Builder showBgdToast(boolean showBgdToast) {
            this.showBgdToast = showBgdToast;
            return this;
        }

        @NotNull
        public final Builder forcedUpgrade(boolean forcedUpgrade) {
            this.forcedUpgrade = forcedUpgrade;
            return this;
        }

        @NotNull
        public final Builder notifyId(int notifyId) {
            this.notifyId = notifyId;
            return this;
        }

        @NotNull
        public final Builder dialogImage(int dialogImage) {
            this.dialogImage = dialogImage;
            return this;
        }

        @NotNull
        public final Builder dialogButtonColor(int dialogButtonColor) {
            this.dialogButtonColor = dialogButtonColor;
            return this;
        }

        @NotNull
        public final Builder dialogButtonTextColor(int dialogButtonTextColor) {
            this.dialogButtonTextColor = dialogButtonTextColor;
            return this;
        }

        @NotNull
        public final Builder dialogProgressBarColor(int dialogProgressBarColor) {
            this.dialogProgressBarColor = dialogProgressBarColor;
            return this;
        }

        @NotNull
        public final Builder enableLog(boolean enable) {
            LogUtil.Companion.enable(enable);
            return this;
        }

        @NotNull
        public final DownloadManager build() {
            DownloadManager downloadManager = Companion.getInstance$appupdate_release(this);
            Intrinsics.checkNotNull((Object)downloadManager);
            return downloadManager;
        }
    }
}

