/*
 * Decompiled with CFR 0.152.
 */
package io.github.azaiats.androidmvvm.navigation.common;

import android.support.annotation.Nullable;
import io.github.azaiats.androidmvvm.core.common.BaseViewModel;
import io.github.azaiats.androidmvvm.navigation.common.NavigationCommand;
import io.github.azaiats.androidmvvm.navigation.common.Navigator;

public abstract class NavigatingViewModel<T extends Navigator>
extends BaseViewModel {
    @Nullable
    protected T navigator;
    @Nullable
    protected NavigationCommand<T> pendingCommand;

    public void setNavigator(@Nullable T navigator) {
        this.navigator = navigator;
        if (navigator != null && this.pendingCommand != null) {
            this.pendingCommand.execute(navigator);
            this.pendingCommand = null;
        }
    }

    public void executeNavigationCommand(NavigationCommand<T> navigationCommand) {
        if (navigationCommand == null) {
            return;
        }
        T vmNavigator = this.navigator;
        if (vmNavigator == null) {
            this.pendingCommand = navigationCommand;
        } else {
            navigationCommand.execute(vmNavigator);
        }
    }
}

