/*
 * Decompiled with CFR 0.152.
 */
package com.anylife.downloadinstaller;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Looper;
import android.util.Log;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.collection.ArrayMap;
import androidx.core.app.NotificationCompat;
import androidx.core.content.FileProvider;
import com.anylife.downloadinstaller.AppUtils;
import com.anylife.downloadinstaller.DownloadProgressCallBack;
import com.anylife.downloadinstaller.R;
import com.dylanc.activityresult.launcher.StartActivityLauncher;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DownloadInstaller {
    private String authority;
    private static final String intentType = "application/vnd.android.package-archive";
    private NotificationManager notificationManager;
    private Notification notification;
    private NotificationCompat.Builder builder;
    private Context mContext;
    private int progress;
    private int oldProgress;
    private boolean isForceGrantUnKnowSource;
    private String downloadApkUrl;
    private String downloadApkUrlMd5;
    private int downloadApkNotifyId;
    private String storageApkPath;
    private DownloadProgressCallBack downloadProgressCallBack;
    public static ArrayMap<String, Integer> downLoadStatusMap = new ArrayMap();
    private String storagePrefix;
    private boolean isDownloadOnly = false;
    private StartActivityLauncher startActivityLauncher;
    private Runnable mDownApkRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block19: {
                downLoadStatusMap.put((Object)DownloadInstaller.this.downloadApkUrlMd5, (Object)0);
                try {
                    int byteCount;
                    File apkFile;
                    URL url = new URL(DownloadInstaller.this.downloadApkUrl);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.connect();
                    conn.setInstanceFollowRedirects(false);
                    if (conn.getResponseCode() == 302) {
                        String location = conn.getHeaderField("Location");
                        conn.disconnect();
                        DownloadInstaller.this.downloadApkUrl = location;
                        conn = (HttpURLConnection)new URL(DownloadInstaller.this.downloadApkUrl).openConnection();
                    }
                    int length = conn.getContentLength();
                    File file = new File(DownloadInstaller.this.storagePrefix);
                    if (!file.exists()) {
                        file.mkdir();
                    }
                    if ((apkFile = new File(DownloadInstaller.this.storageApkPath)).exists() && apkFile.length() == (long)length) {
                        DownloadInstaller.this.progress = 100;
                        DownloadInstaller.this.updateNotify(DownloadInstaller.this.progress);
                        if (DownloadInstaller.this.downloadProgressCallBack != null) {
                            DownloadInstaller.this.downloadProgressCallBack.downloadProgress(DownloadInstaller.this.progress);
                        }
                        conn.disconnect();
                        if (!DownloadInstaller.this.isDownloadOnly) {
                            ((Activity)DownloadInstaller.this.mContext).runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    downLoadStatusMap.put((Object)DownloadInstaller.this.downloadApkUrlMd5, (Object)2);
                                    DownloadInstaller.this.installProcess();
                                }
                            });
                        }
                        return;
                    }
                    FileOutputStream fos = new FileOutputStream(apkFile);
                    int count = 0;
                    byte[] buf = new byte[2048];
                    InputStream is = conn.getInputStream();
                    while ((byteCount = is.read(buf)) > 0) {
                        DownloadInstaller.this.progress = (int)((float)(count += byteCount) / (float)length * 100.0f);
                        if (DownloadInstaller.this.progress > DownloadInstaller.this.oldProgress) {
                            DownloadInstaller.this.updateNotify(DownloadInstaller.this.progress);
                            if (DownloadInstaller.this.downloadProgressCallBack != null) {
                                DownloadInstaller.this.downloadProgressCallBack.downloadProgress(DownloadInstaller.this.progress);
                            }
                            DownloadInstaller.this.oldProgress = DownloadInstaller.this.progress;
                        }
                        fos.write(buf, 0, byteCount);
                    }
                    if (!DownloadInstaller.this.isDownloadOnly) {
                        ((Activity)DownloadInstaller.this.mContext).runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                downLoadStatusMap.put((Object)DownloadInstaller.this.downloadApkUrlMd5, (Object)2);
                                DownloadInstaller.this.installProcess();
                            }
                        });
                    }
                    fos.flush();
                    fos.close();
                    is.close();
                }
                catch (Exception e) {
                    downLoadStatusMap.put((Object)DownloadInstaller.this.downloadApkUrlMd5, (Object)1);
                    if (DownloadInstaller.this.downloadProgressCallBack != null) {
                        DownloadInstaller.this.downloadProgressCallBack.downloadException(e);
                    }
                    if (e instanceof FileNotFoundException) {
                        DownloadInstaller.this.notifyError(DownloadInstaller.this.getStringFrom(R.string.download_failure_file_not_found));
                        DownloadInstaller.this.toastError(R.string.download_failure_file_not_found);
                        break block19;
                    }
                    if (e instanceof ConnectException) {
                        DownloadInstaller.this.notifyError(DownloadInstaller.this.getStringFrom(R.string.download_failure_net_deny));
                        DownloadInstaller.this.toastError(R.string.download_failure_net_deny);
                        break block19;
                    }
                    if (e instanceof UnknownHostException) {
                        DownloadInstaller.this.notifyError(DownloadInstaller.this.getStringFrom(R.string.download_failure_net_deny));
                        DownloadInstaller.this.toastError(R.string.download_failure_net_deny);
                        break block19;
                    }
                    if (e instanceof UnknownServiceException) {
                        DownloadInstaller.this.notifyError(DownloadInstaller.this.getStringFrom(R.string.download_failure_net_deny));
                        DownloadInstaller.this.toastError(R.string.download_failure_net_deny);
                        break block19;
                    }
                    if (e.toString().contains("Permission denied")) {
                        DownloadInstaller.this.notifyError(DownloadInstaller.this.getStringFrom(R.string.download_failure_storage_permission_deny));
                        DownloadInstaller.this.toastError(R.string.download_failure_storage_permission_deny);
                        break block19;
                    }
                    DownloadInstaller.this.notifyError(DownloadInstaller.this.getStringFrom(R.string.apk_update_download_failed));
                    DownloadInstaller.this.toastError(R.string.apk_update_download_failed);
                    Log.i((String)"89898989", (String)e.toString());
                }
            }
        }
    };

    public DownloadInstaller(Context context, String downloadApkUrl, StartActivityLauncher startActivityLauncher) {
        this(context, downloadApkUrl, startActivityLauncher, false, null);
    }

    public DownloadInstaller(Context context, String downloadApkUrl, StartActivityLauncher startActivityLauncher, DownloadProgressCallBack callBack) {
        this(context, downloadApkUrl, startActivityLauncher, false, callBack);
    }

    public DownloadInstaller(Context context, String downloadApkUrl, StartActivityLauncher startActivityLauncher, boolean isForceGrantUnKnowSource, DownloadProgressCallBack callBack) {
        this.mContext = context;
        this.downloadApkUrl = downloadApkUrl;
        this.startActivityLauncher = startActivityLauncher;
        this.isForceGrantUnKnowSource = isForceGrantUnKnowSource;
        this.downloadProgressCallBack = callBack;
    }

    private void setDownloadOnly(boolean isDownloadOnly) {
        this.isDownloadOnly = isDownloadOnly;
    }

    private String getUpperMD5Str16(String str) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(str.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("NoSuchAlgorithmException caught!");
            System.exit(-1);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        byte[] byteArray = messageDigest.digest();
        StringBuffer md5StrBuff = new StringBuffer();
        for (int i = 0; i < byteArray.length; ++i) {
            if (Integer.toHexString(0xFF & byteArray[i]).length() == 1) {
                md5StrBuff.append("0").append(Integer.toHexString(0xFF & byteArray[i]));
                continue;
            }
            md5StrBuff.append(Integer.toHexString(0xFF & byteArray[i]));
        }
        return md5StrBuff.toString().toUpperCase().substring(8, 24);
    }

    private void deleteOthersFiles(String path, String downloadApkUrlMd5) {
        File file = new File(path);
        File[] files = file.listFiles();
        if (files == null || files.length == 0) {
            Log.e((String)"error", (String)"\u7a7a\u76ee\u5f55");
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getAbsoluteFile().getName().contains(downloadApkUrlMd5) || Math.abs(files[i].lastModified() - System.currentTimeMillis()) <= 172800000L) continue;
            files[i].delete();
        }
    }

    public void start() {
        String applicationID = this.mContext.getPackageName();
        this.downloadApkUrlMd5 = this.getUpperMD5Str16(this.downloadApkUrl + applicationID);
        this.downloadApkNotifyId = this.downloadApkUrlMd5.hashCode();
        this.authority = applicationID + ".fileProvider";
        this.storagePrefix = Build.VERSION.SDK_INT < 24 ? Environment.getExternalStorageDirectory().getPath() + "/update/" : this.mContext.getFilesDir().getPath() + "/update/";
        this.deleteOthersFiles(this.storagePrefix, this.downloadApkUrlMd5);
        this.storageApkPath = this.storagePrefix + AppUtils.getAppName(this.mContext) + this.downloadApkUrlMd5 + ".apk";
        Integer downloadStatus = (Integer)downLoadStatusMap.get((Object)this.downloadApkUrlMd5);
        if (downloadStatus == null || downloadStatus == -1 || downloadStatus == 1) {
            this.initNotification();
            new Thread(this.mDownApkRunnable).start();
        } else if (downloadStatus == 0) {
            Toast.makeText((Context)this.mContext, (CharSequence)"\u6b63\u5728\u4e0b\u8f7dApp", (int)0).show();
        } else if (downloadStatus == 2) {
            if (null != this.downloadProgressCallBack) {
                this.downloadProgressCallBack.downloadProgress(100);
            }
            if (!this.isDownloadOnly) {
                ((Activity)this.mContext).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        downLoadStatusMap.put((Object)DownloadInstaller.this.downloadApkUrlMd5, (Object)2);
                        DownloadInstaller.this.installProcess();
                    }
                });
            }
        }
    }

    @NonNull
    public String getStringFrom(@StringRes int id) {
        return this.mContext.getResources().getString(id);
    }

    private void toastError(@StringRes int id) {
        Looper.prepare();
        Toast.makeText((Context)this.mContext, (CharSequence)this.getStringFrom(id), (int)1).show();
        Looper.loop();
    }

    public void installProcess() {
        if (this.isDownloadOnly) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            boolean canInstallPackage = this.mContext.getPackageManager().canRequestPackageInstalls();
            Integer downloadStatus = (Integer)downLoadStatusMap.get((Object)this.downloadApkUrlMd5);
            if (canInstallPackage) {
                if (downloadStatus == 2) {
                    this.installApk();
                    downLoadStatusMap.put((Object)this.downloadApkUrlMd5, (Object)-1);
                }
            } else {
                Uri packageURI = Uri.parse((String)("package:" + AppUtils.getPackageName(this.mContext)));
                Intent intent = new Intent("android.settings.MANAGE_UNKNOWN_APP_SOURCES", packageURI);
                this.startActivityLauncher.launch((Object)intent, result -> {
                    if (result.getResultCode() == -1) {
                        if (downloadStatus == 2) {
                            this.installProcess();
                        }
                    } else if (this.isForceGrantUnKnowSource) {
                        this.installProcess();
                    } else {
                        Toast.makeText((Context)this.mContext, (CharSequence)"\u4f60\u6ca1\u6709\u6388\u6743\u5b89\u88c5App", (int)1).show();
                    }
                });
            }
        } else {
            this.installApk();
            downLoadStatusMap.put((Object)this.downloadApkUrlMd5, (Object)-1);
        }
    }

    private void installApk() {
        File apkFile = new File(this.storageApkPath);
        if (!apkFile.exists()) {
            return;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        if (Build.VERSION.SDK_INT >= 24) {
            Uri contentUri = FileProvider.getUriForFile((Context)this.mContext, (String)this.authority, (File)apkFile);
            intent.setDataAndType(contentUri, intentType);
            intent.addFlags(1);
        } else {
            intent.setDataAndType(Uri.parse((String)("file://" + apkFile.toString())), intentType);
        }
        intent.addFlags(0x10000000);
        this.mContext.startActivity(intent);
        if (this.downloadProgressCallBack != null) {
            this.downloadProgressCallBack.onInstallStart();
        }
    }

    private void initNotification() {
        this.notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel mChannel = new NotificationChannel(this.downloadApkUrlMd5, (CharSequence)this.downloadApkUrlMd5, 2);
            this.notificationManager.createNotificationChannel(mChannel);
        }
        this.builder = new NotificationCompat.Builder(this.mContext, this.downloadApkUrl);
        this.builder.setContentTitle((CharSequence)this.mContext.getResources().getString(R.string.apk_update_tips_title)).setSmallIcon(R.drawable.download).setDefaults(4).setPriority(2).setAutoCancel(true).setOngoing(true).setContentText((CharSequence)this.mContext.getResources().getString(R.string.apk_update_downloading_progress)).setChannelId(this.downloadApkUrlMd5).setProgress(100, 0, false);
        this.notification = this.builder.build();
    }

    private void notifyError(String errorMsg) {
        this.builder.setContentTitle((CharSequence)this.mContext.getResources().getString(R.string.apk_update_tips_error_title));
        this.builder.setContentText((CharSequence)errorMsg);
        this.notification = this.builder.build();
        this.notificationManager.notify(this.downloadApkNotifyId, this.notification);
    }

    private void updateNotify(int progress) {
        this.builder.setProgress(100, progress, false);
        this.builder.setContentText((CharSequence)(this.mContext.getResources().getString(R.string.apk_update_downloading_progress) + " \u300c" + progress + "%\u300d"));
        this.notification = this.builder.build();
        if (progress == 100) {
            Intent intent = new Intent("android.intent.action.VIEW");
            if (Build.VERSION.SDK_INT >= 24) {
                Uri contentUri = FileProvider.getUriForFile((Context)this.mContext, (String)this.authority, (File)new File(this.storageApkPath));
                intent.setDataAndType(contentUri, intentType);
                intent.addFlags(1);
            } else {
                intent.setDataAndType(Uri.parse((String)("file://" + new File(this.storageApkPath).toString())), intentType);
            }
            intent.addFlags(0x10000000);
            this.notification.contentIntent = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)intent, (int)0x4000000);
        }
        this.notificationManager.notify(this.downloadApkNotifyId, this.notification);
    }
}

