/*
 * Decompiled with CFR 0.152.
 */
package io.github.anderscheow.library.utils;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J$\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\u0004\b\u0000\u0010\u000b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u0002H\u000b\u0018\u00010\rH\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J\u001a\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/github/anderscheow/library/utils/MiscUtil;", "", "()V", "displayMetrics", "Landroid/util/DisplayMetrics;", "calculateNoOfColumns", "", "context", "Landroid/content/Context;", "copyIterator", "", "T", "iterator", "", "getDisplayMetrics", "activity", "Landroid/app/Activity;", "hideKeyboard", "", "view", "Landroid/view/View;", "showKeyboard", "library_release"})
public final class MiscUtil {
    private static DisplayMetrics displayMetrics;
    public static final MiscUtil INSTANCE;

    @Nullable
    public final DisplayMetrics getDisplayMetrics(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        if (displayMetrics == null) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            WindowManager windowManager = activity.getWindowManager();
            Intrinsics.checkExpressionValueIsNotNull((Object)windowManager, (String)"activity.windowManager");
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
            MiscUtil.displayMetrics = displayMetrics;
        }
        return displayMetrics;
    }

    public final int calculateNoOfColumns(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        float dpWidth = (float)displayMetrics.widthPixels / displayMetrics.density;
        return (int)(dpWidth / (float)180);
    }

    @NotNull
    public final <T> List<T> copyIterator(@Nullable Iterator<? extends T> iterator) {
        ArrayList<T> copy = new ArrayList<T>();
        if (iterator != null) {
            while (iterator.hasNext()) {
                copy.add(iterator.next());
            }
        }
        return copy;
    }

    public final void showKeyboard(@NotNull Context context, @Nullable View view) {
        block2: {
            View view2;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            View view3 = view;
            if (view3 == null) break block2;
            View it = view2 = view3;
            it.requestFocus();
            Object object = context.getSystemService("input_method");
            if (!(object instanceof InputMethodManager)) {
                object = null;
            }
            InputMethodManager inputMethodManager = (InputMethodManager)object;
            if (inputMethodManager != null) {
                inputMethodManager.toggleSoftInput(2, 1);
            }
        }
    }

    public final void hideKeyboard(@NotNull Context context, @Nullable View view) {
        block2: {
            View view2;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            View view3 = view;
            if (view3 == null) break block2;
            View it = view2 = view3;
            Object object = context.getSystemService("input_method");
            if (!(object instanceof InputMethodManager)) {
                object = null;
            }
            InputMethodManager inputMethodManager = (InputMethodManager)object;
            if (inputMethodManager != null) {
                inputMethodManager.hideSoftInputFromWindow(it.getWindowToken(), 0);
            }
        }
    }

    private MiscUtil() {
    }

    static {
        MiscUtil miscUtil;
        INSTANCE = miscUtil = new MiscUtil();
    }
}

