/*
 * Decompiled with CFR 0.152.
 */
package io.github.anderscheow.library.adapters.view_holder;

import android.databinding.ViewDataBinding;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import butterknife.BindView;
import io.github.anderscheow.library.adapters.view_holder.MyBaseViewHolder;
import io.github.anderscheow.library.constant.NetworkState;
import io.github.anderscheow.library.databinding.ViewNetworkStateBinding;

public class NetworkStateViewHolder
extends MyBaseViewHolder<NetworkState> {
    @BindView(value=2131492892)
    Button buttonRetry;
    @BindView(value=2131492997)
    TextView textViewErrorMsg;
    private RetryCallback callback;
    @StringRes
    private Integer errorMessage;

    private NetworkStateViewHolder(ViewNetworkStateBinding binding, RetryCallback callback) {
        super((ViewDataBinding)binding);
        this.callback = callback;
    }

    private NetworkStateViewHolder(ViewNetworkStateBinding binding, RetryCallback callback, @StringRes Integer errorMessage) {
        super((ViewDataBinding)binding);
        this.callback = callback;
        this.errorMessage = errorMessage;
    }

    public static NetworkStateViewHolder create(@NonNull ViewNetworkStateBinding binding, RetryCallback callback) {
        return new NetworkStateViewHolder(binding, callback);
    }

    public static NetworkStateViewHolder create(@NonNull ViewNetworkStateBinding binding, RetryCallback callback, @StringRes Integer errorMessage) {
        return new NetworkStateViewHolder(binding, callback);
    }

    @Override
    protected void extraBinding(NetworkState networkState) {
        this.buttonRetry.setOnClickListener(v -> {
            if (this.callback != null) {
                this.callback.retry();
            }
        });
        if (this.errorMessage != null) {
            this.textViewErrorMsg.setText(this.errorMessage.intValue());
        }
    }

    @Override
    protected void onClick(@NonNull View view, NetworkState item) {
    }

    public static interface RetryCallback {
        public void retry();
    }
}

