/*
 * Decompiled with CFR 0.152.
 */
package io.github.anderscheow.library.base.live.view_model;

import android.app.Application;
import android.arch.lifecycle.AndroidViewModel;
import android.databinding.ObservableBoolean;
import android.support.annotation.StringRes;
import io.github.anderscheow.library.base.live.util.ProgressDialogMessage;
import io.github.anderscheow.library.base.live.util.ToastMessage;
import io.reactivex.disposables.CompositeDisposable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0004J\b\u0010\u0017\u001a\u00020\u0016H\u0014J\b\u0010\u0018\u001a\u00020\u0016H&J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J\u0012\u0010\u001c\u001a\u00020\u00162\b\b\u0001\u0010\u001d\u001a\u00020\u001eH\u0004J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020 H\u0004J\u0006\u0010!\u001a\u00020\u0016J\u0017\u0010!\u001a\u00020\u00162\b\u0010\"\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0002\u0010#R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006$"}, d2={"Lio/github/anderscheow/library/base/live/view_model/BaseAndroidViewModel;", "T", "Landroid/arch/lifecycle/AndroidViewModel;", "context", "Landroid/app/Application;", "(Landroid/app/Application;)V", "disposable", "Lio/reactivex/disposables/CompositeDisposable;", "getDisposable", "()Lio/reactivex/disposables/CompositeDisposable;", "isLoading", "Landroid/databinding/ObservableBoolean;", "()Landroid/databinding/ObservableBoolean;", "progressDialogMessage", "Lio/github/anderscheow/library/base/live/util/ProgressDialogMessage;", "getProgressDialogMessage", "()Lio/github/anderscheow/library/base/live/util/ProgressDialogMessage;", "toastMessage", "Lio/github/anderscheow/library/base/live/util/ToastMessage;", "getToastMessage", "()Lio/github/anderscheow/library/base/live/util/ToastMessage;", "dismissProgressDialog", "", "onCleared", "onRefresh", "setIsLoading", "value", "", "showProgressDialog", "message", "", "showToast", "", "start", "args", "(Ljava/lang/Object;)V", "library_release"})
public abstract class BaseAndroidViewModel<T>
extends AndroidViewModel {
    @NotNull
    private final ObservableBoolean isLoading;
    @NotNull
    private final ToastMessage toastMessage;
    @NotNull
    private final ProgressDialogMessage progressDialogMessage;
    @NotNull
    private final CompositeDisposable disposable;

    @NotNull
    public final ObservableBoolean isLoading() {
        return this.isLoading;
    }

    @NotNull
    public final ToastMessage getToastMessage() {
        return this.toastMessage;
    }

    @NotNull
    public final ProgressDialogMessage getProgressDialogMessage() {
        return this.progressDialogMessage;
    }

    @NotNull
    protected final CompositeDisposable getDisposable() {
        return this.disposable;
    }

    public abstract void start(@Nullable T var1);

    public abstract void onRefresh();

    protected void onCleared() {
        super.onCleared();
        this.disposable.clear();
    }

    protected final void showProgressDialog(@StringRes int message) {
        this.progressDialogMessage.postValue(message);
    }

    protected final void dismissProgressDialog() {
        this.progressDialogMessage.postValue(-1);
    }

    protected final void showToast(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.toastMessage.postValue(message);
    }

    protected final void setIsLoading(boolean value) {
        this.isLoading.set(value);
        this.isLoading.notifyChange();
    }

    public final void start() {
        this.start(null);
    }

    public BaseAndroidViewModel(@NotNull Application context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.isLoading = new ObservableBoolean(false);
        this.toastMessage = new ToastMessage();
        this.progressDialogMessage = new ProgressDialogMessage();
        this.disposable = new CompositeDisposable();
    }
}

