/*
 * Decompiled with CFR 0.152.
 */
package io.github.anderscheow.library.paging;

import android.arch.lifecycle.MutableLiveData;
import android.arch.paging.ItemKeyedDataSource;
import android.support.annotation.CallSuper;
import io.github.anderscheow.library.constant.NetworkState;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0019\u001a\u00020\u001aH\u0004J$\u0010\u001b\u001a\u00020\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00010\u001fH\u0017J$\u0010 \u001a\u00020\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00010\u001fH\u0017J$\u0010!\u001a\u00020\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\"2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00010#H\u0017J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&H\u0004J\b\u0010'\u001a\u00020\u001aH\u0004J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u0017H\u0004J\u0006\u0010\u0013\u001a\u00020\u001aR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000b\u00a8\u0006)"}, d2={"Lio/github/anderscheow/library/paging/BaseItemKeyedDataSource;", "Key", "Value", "Landroid/arch/paging/ItemKeyedDataSource;", "retryExecutor", "Ljava/util/concurrent/Executor;", "(Ljava/util/concurrent/Executor;)V", "networkState", "Landroid/arch/lifecycle/MutableLiveData;", "Lio/github/anderscheow/library/constant/NetworkState;", "getNetworkState", "()Landroid/arch/lifecycle/MutableLiveData;", "<set-?>", "", "pageNumber", "getPageNumber", "()I", "setPageNumber", "(I)V", "retry", "Lkotlin/Function0;", "", "totalItems", "", "getTotalItems", "incrementPageNumber", "", "loadAfter", "params", "Landroid/arch/paging/ItemKeyedDataSource$LoadParams;", "callback", "Landroid/arch/paging/ItemKeyedDataSource$LoadCallback;", "loadBefore", "loadInitial", "Landroid/arch/paging/ItemKeyedDataSource$LoadInitialParams;", "Landroid/arch/paging/ItemKeyedDataSource$LoadInitialCallback;", "postFailedValue", "errorMessage", "", "postSuccessValue", "totalOfElements", "library_release"})
public abstract class BaseItemKeyedDataSource<Key, Value>
extends ItemKeyedDataSource<Key, Value> {
    private Function0<? extends Object> retry;
    @NotNull
    private final MutableLiveData<NetworkState> networkState;
    @NotNull
    private final MutableLiveData<Long> totalItems;
    private int pageNumber;
    private final Executor retryExecutor;

    @NotNull
    public final MutableLiveData<NetworkState> getNetworkState() {
        return this.networkState;
    }

    @NotNull
    public final MutableLiveData<Long> getTotalItems() {
        return this.totalItems;
    }

    public final int getPageNumber() {
        return this.pageNumber;
    }

    private final void setPageNumber(int n) {
        this.pageNumber = n;
    }

    @CallSuper
    public void loadInitial(@NotNull ItemKeyedDataSource.LoadInitialParams<Key> params, @NotNull ItemKeyedDataSource.LoadInitialCallback<Value> callback) {
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.retry = (Function0)new Function0<Unit>(this, params, callback){
            final /* synthetic */ BaseItemKeyedDataSource this$0;
            final /* synthetic */ ItemKeyedDataSource.LoadInitialParams $params;
            final /* synthetic */ ItemKeyedDataSource.LoadInitialCallback $callback;

            public final void invoke() {
                this.this$0.loadInitial(this.$params, this.$callback);
            }
            {
                this.this$0 = baseItemKeyedDataSource;
                this.$params = loadInitialParams;
                this.$callback = loadInitialCallback;
                super(0);
            }
        };
        this.networkState.postValue((Object)NetworkState.Companion.getLOADING());
    }

    @CallSuper
    public void loadAfter(@NotNull ItemKeyedDataSource.LoadParams<Key> params, @NotNull ItemKeyedDataSource.LoadCallback<Value> callback) {
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.retry = (Function0)new Function0<Unit>(this, params, callback){
            final /* synthetic */ BaseItemKeyedDataSource this$0;
            final /* synthetic */ ItemKeyedDataSource.LoadParams $params;
            final /* synthetic */ ItemKeyedDataSource.LoadCallback $callback;

            public final void invoke() {
                this.this$0.loadAfter(this.$params, this.$callback);
            }
            {
                this.this$0 = baseItemKeyedDataSource;
                this.$params = loadParams;
                this.$callback = loadCallback;
                super(0);
            }
        };
        this.networkState.postValue((Object)NetworkState.Companion.getLOADING());
    }

    @CallSuper
    public void loadBefore(@NotNull ItemKeyedDataSource.LoadParams<Key> params, @NotNull ItemKeyedDataSource.LoadCallback<Value> callback) {
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
    }

    protected final void incrementPageNumber() {
        ++this.pageNumber;
    }

    protected final void postSuccessValue() {
        this.networkState.postValue((Object)NetworkState.Companion.getLOADED());
        this.retry = null;
    }

    protected final void postSuccessValue(long totalOfElements) {
        this.networkState.postValue((Object)NetworkState.Companion.getLOADED());
        this.totalItems.postValue((Object)totalOfElements);
        this.retry = null;
    }

    protected final void postFailedValue(@NotNull String errorMessage) {
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        this.networkState.postValue((Object)NetworkState.Companion.error(errorMessage));
    }

    public final void retry() {
        block0: {
            Function0<? extends Object> function0;
            Function0<? extends Object> prevRetry = this.retry;
            this.retry = null;
            Function0<? extends Object> function02 = prevRetry;
            if (function02 == null) break block0;
            Function0<? extends Object> it = function0 = function02;
            this.retryExecutor.execute(new Runnable(it){
                final /* synthetic */ Function0 $it;

                public final void run() {
                    this.$it.invoke();
                }
                {
                    this.$it = function0;
                }
            });
        }
    }

    public BaseItemKeyedDataSource(@NotNull Executor retryExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)retryExecutor, (String)"retryExecutor");
        this.retryExecutor = retryExecutor;
        this.networkState = new MutableLiveData();
        this.totalItems = new MutableLiveData();
        this.pageNumber = 1;
    }
}

