/*
 * Decompiled with CFR 0.152.
 */
package io.github.anderscheow.library.services;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.IBinder;
import io.github.anderscheow.library.base.BaseAppCompatActivity;
import io.github.anderscheow.library.services.ApplicationService;
import io.github.anderscheow.library.services.ApplicationServiceReadyCallback;
import io.github.anderscheow.library.services.ApplicationServiceScheduler;
import java.util.LinkedList;
import java.util.Queue;

public abstract class ServiceBoundAppCompatActivity<T extends ApplicationService>
extends BaseAppCompatActivity
implements ServiceConnection {
    private ApplicationServiceScheduler scheduler;
    private boolean bound;
    private Queue<ApplicationServiceReadyCallback<T>> callbackQueue;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.callbackQueue = new LinkedList<ApplicationServiceReadyCallback<T>>();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.bound) {
            this.unbindService(this);
        }
    }

    public void onServiceConnected(ComponentName name, IBinder service) {
        ApplicationService.ApplicationContextServiceBinder binder = (ApplicationService.ApplicationContextServiceBinder)service;
        this.scheduler = binder.getScheduler();
        this.bound = true;
        while (!this.callbackQueue.isEmpty()) {
            this.scheduler.scheduleForService(this.callbackQueue.remove());
        }
    }

    public void onServiceDisconnected(ComponentName name) {
        this.scheduler = null;
        this.bound = false;
    }

    public void scheduleForService(ApplicationServiceReadyCallback<T> callback) {
        UiThreadCallback threadedCallback = new UiThreadCallback(callback);
        if (!this.bound) {
            this.callbackQueue.add(threadedCallback);
            this.startService(ApplicationService.newIntent((Context)this));
        } else {
            this.scheduler.scheduleForService(threadedCallback);
        }
    }

    public synchronized boolean isConnectedToInternet() {
        ConnectivityManager cm = (ConnectivityManager)this.getApplicationContext().getSystemService("connectivity");
        NetworkInfo netInfo = cm != null ? cm.getActiveNetworkInfo() : null;
        return netInfo != null && netInfo.isConnectedOrConnecting() && !netInfo.isRoaming();
    }

    public abstract void startService();

    private class UiThreadCallback
    implements ApplicationServiceReadyCallback<T>,
    Runnable {
        private ApplicationServiceReadyCallback<T> callback;
        private T service;

        UiThreadCallback(ApplicationServiceReadyCallback<T> callback) {
            this.callback = callback;
        }

        @Override
        public void onServiceReady(T service) {
            this.service = service;
            ServiceBoundAppCompatActivity.this.runOnUiThread(this);
        }

        @Override
        public void run() {
            this.callback.onServiceReady(this.service);
        }
    }
}

