/*
 * Decompiled with CFR 0.152.
 */
package com.aghajari.zoomhelper;

import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.aghajari.zoomhelper.ZoomHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002J)\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0010\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0011J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u0014J2\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/aghajari/zoomhelper/Utils;", "", "()V", "checkChild", "Landroid/view/View;", "vg", "Landroid/view/ViewGroup;", "x1", "", "y1", "x2", "y2", "findZoomableView", "ev", "Landroid/view/MotionEvent;", "parents", "", "(Landroid/view/MotionEvent;[Landroid/view/View;)Landroid/view/View;", "getDistance", "", "", "isViewInArea", "", "view", "ZoomHelper_release"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    @Nullable
    public final View findZoomableView(@NotNull MotionEvent ev, View ... parents) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        Intrinsics.checkNotNullParameter((Object)parents, (String)"parents");
        View[] viewArray = parents;
        boolean bl = false;
        if (viewArray.length == 0) {
            return null;
        }
        MotionEvent.PointerCoords p1 = new MotionEvent.PointerCoords();
        ev.getPointerCoords(0, p1);
        MotionEvent.PointerCoords p2 = new MotionEvent.PointerCoords();
        ev.getPointerCoords(1, p2);
        for (View parent : parents) {
            if (ZoomHelper.Companion.isSkippingLayout(parent)) continue;
            if (!this.isViewInArea(parent, p1.x, p1.y, p2.x, p2.y) || !ZoomHelper.Companion.isZoomableView(parent)) continue;
            return parent;
        }
        return null;
    }

    private final View checkChild(ViewGroup vg, float x1, float y1, float x2, float y2) {
        if (vg == null) {
            return null;
        }
        int n = 0;
        int childCount = vg.getChildCount();
        if (n < childCount) {
            do {
                View v;
                int i = n++;
                View child = vg.getChildAt(i);
                Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                if (ZoomHelper.Companion.isSkippingLayout(child) || !this.isViewInArea(child, x1, y1, x2, y2)) continue;
                if (ZoomHelper.Companion.isZoomableView(child)) {
                    return child;
                }
                if (!(child instanceof ViewGroup) || (v = this.checkChild((ViewGroup)child, x1, y1, x2, y2)) == null) continue;
                return v;
            } while (n < childCount);
        }
        return null;
    }

    private final boolean isViewInArea(View view, float x1, float y1, float x2, float y2) {
        if (view == null) {
            return false;
        }
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        Rect visibleRect = new Rect();
        visibleRect.left = location[0];
        visibleRect.top = location[1];
        visibleRect.right = visibleRect.left + view.getWidth();
        visibleRect.bottom = visibleRect.top + view.getHeight();
        return visibleRect.contains((int)x1, (int)y1) && visibleRect.contains((int)x2, (int)y2);
    }

    public final int getDistance(double x1, double y1, double x2, double y2) {
        return (int)Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
    }
}

