/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.rajat.pdfviewer.PdfDownloader;
import com.rajat.pdfviewer.PdfEngine;
import com.rajat.pdfviewer.PdfQuality;
import com.rajat.pdfviewer.PdfRendererCore;
import com.rajat.pdfviewer.PdfRendererView;
import com.rajat.pdfviewer.PdfViewAdapter;
import com.rajat.pdfviewer.R;
import java.io.File;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000}\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u001a\u0018\u00002\u00020\u0001:\u000289B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010&\u001a\u00020'J\u001a\u0010(\u001a\u00020'2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010)\u001a\u00020\u0007H\u0002J\u0018\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0014H\u0002J\u0010\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u000200H\u0003J\u0018\u00101\u001a\u00020'2\u0006\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020\u0014J\u0018\u00102\u001a\u00020'2\u0006\u00103\u001a\u0002002\b\b\u0002\u0010-\u001a\u00020\u0014J\"\u00104\u001a\u00020'2\u0006\u0010/\u001a\u0002002\b\b\u0002\u0010-\u001a\u00020\u00142\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0010\u00105\u001a\u00020'2\u0006\u00106\u001a\u000207H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006:"}, d2={"Lcom/rajat/pdfviewer/PdfRendererView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "divider", "Landroid/graphics/drawable/Drawable;", "engine", "Lcom/rajat/pdfviewer/PdfEngine;", "pdfRendererCore", "Lcom/rajat/pdfviewer/PdfRendererCore;", "pdfRendererCoreInitialised", "", "pdfViewAdapter", "Lcom/rajat/pdfviewer/PdfViewAdapter;", "quality", "Lcom/rajat/pdfviewer/PdfQuality;", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "runnable", "Ljava/lang/Runnable;", "scrollListener", "com/rajat/pdfviewer/PdfRendererView$scrollListener$1", "Lcom/rajat/pdfviewer/PdfRendererView$scrollListener$1;", "showDivider", "statusListener", "Lcom/rajat/pdfviewer/PdfRendererView$StatusCallBack;", "getStatusListener", "()Lcom/rajat/pdfviewer/PdfRendererView$StatusCallBack;", "setStatusListener", "(Lcom/rajat/pdfviewer/PdfRendererView$StatusCallBack;)V", "totalPageCount", "getTotalPageCount", "()I", "closePdfRender", "", "getAttrs", "defStyle", "init", "file", "Ljava/io/File;", "pdfQuality", "initUnderKitkat", "url", "", "initWithFile", "initWithPath", "path", "initWithUrl", "setTypeArray", "typedArray", "Landroid/content/res/TypedArray;", "PdfWebViewClient", "StatusCallBack", "pdfViewer_release"})
public final class PdfRendererView
extends FrameLayout {
    private RecyclerView recyclerView;
    private PdfRendererCore pdfRendererCore;
    private PdfViewAdapter pdfViewAdapter;
    @NotNull
    private PdfQuality quality;
    @NotNull
    private PdfEngine engine;
    private boolean showDivider;
    @Nullable
    private Drawable divider;
    @NotNull
    private Runnable runnable;
    private boolean pdfRendererCoreInitialised;
    @Nullable
    private StatusCallBack statusListener;
    @NotNull
    private final scrollListener.1 scrollListener;
    @NotNull
    public Map<Integer, View> _$_findViewCache;

    @JvmOverloads
    public PdfRendererView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this._$_findViewCache = new LinkedHashMap();
        super(context, attrs, defStyleAttr);
        this.quality = PdfQuality.NORMAL;
        this.engine = PdfEngine.INTERNAL;
        this.showDivider = true;
        this.runnable = PdfRendererView::runnable$lambda-0;
        this.scrollListener = new RecyclerView.OnScrollListener(this){
            final /* synthetic */ PdfRendererView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
                block4: {
                    int foundPosition;
                    LinearLayoutManager $this$onScrolled_u24lambda_u2d2;
                    PdfRendererView pdfRendererView;
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
                        super.onScrolled(recyclerView, dx, dy);
                        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type androidx.recyclerview.widget.LinearLayoutManager");
                        LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
                        pdfRendererView = this.this$0;
                        $this$onScrolled_u24lambda_u2d2 = linearLayoutManager;
                        boolean bl = false;
                        foundPosition = 0;
                        foundPosition = $this$onScrolled_u24lambda_u2d2.findFirstCompletelyVisibleItemPosition();
                        TextView $this$onScrolled_u24lambda_u2d2_u24lambda_u2d0 = (TextView)pdfRendererView._$_findCachedViewById(R.id.pageNo);
                        boolean bl2 = false;
                        if (foundPosition != -1) {
                            $this$onScrolled_u24lambda_u2d2_u24lambda_u2d0.setText((CharSequence)(foundPosition + 1 + " of " + pdfRendererView.getTotalPageCount()));
                        }
                        ((TextView)$this$onScrolled_u24lambda_u2d2_u24lambda_u2d0.findViewById(R.id.pageNo)).setVisibility(0);
                        if (foundPosition == 0) {
                            ((TextView)pdfRendererView._$_findCachedViewById(R.id.pageNo)).postDelayed(() -> scrollListener.1.onScrolled$lambda-2$lambda-1(pdfRendererView), 3000L);
                        }
                        if (foundPosition == -1) break block3;
                        StatusCallBack statusCallBack = pdfRendererView.getStatusListener();
                        if (statusCallBack == null) break block4;
                        statusCallBack.onPageChanged(foundPosition, pdfRendererView.getTotalPageCount());
                        break block4;
                    }
                    foundPosition = $this$onScrolled_u24lambda_u2d2.findFirstVisibleItemPosition();
                    if (foundPosition == -1) break block4;
                    StatusCallBack statusCallBack = pdfRendererView.getStatusListener();
                    if (statusCallBack != null) {
                        statusCallBack.onPageChanged(foundPosition, pdfRendererView.getTotalPageCount());
                    }
                }
            }

            public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
                Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
                super.onScrollStateChanged(recyclerView, newState);
                if (newState == 0) {
                    ((TextView)this.this$0._$_findCachedViewById(R.id.pageNo)).postDelayed(PdfRendererView.access$getRunnable$p(this.this$0), 3000L);
                } else {
                    ((TextView)this.this$0._$_findCachedViewById(R.id.pageNo)).removeCallbacks(PdfRendererView.access$getRunnable$p(this.this$0));
                }
            }

            private static final void onScrolled$lambda-2$lambda-1(PdfRendererView this$0) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                ((TextView)this$0._$_findCachedViewById(R.id.pageNo)).setVisibility(8);
            }
        };
        this.getAttrs(attrs, defStyleAttr);
    }

    public /* synthetic */ PdfRendererView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @Nullable
    public final StatusCallBack getStatusListener() {
        return this.statusListener;
    }

    public final void setStatusListener(@Nullable StatusCallBack statusCallBack) {
        this.statusListener = statusCallBack;
    }

    public final int getTotalPageCount() {
        PdfRendererCore pdfRendererCore = this.pdfRendererCore;
        if (pdfRendererCore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdfRendererCore");
            pdfRendererCore = null;
        }
        return pdfRendererCore.getPageCount();
    }

    public final void initWithUrl(@NotNull String url, @NotNull PdfQuality pdfQuality, @NotNull PdfEngine engine) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)((Object)pdfQuality), (String)"pdfQuality");
        Intrinsics.checkNotNullParameter((Object)((Object)engine), (String)"engine");
        if (Build.VERSION.SDK_INT < 21 || engine == PdfEngine.GOOGLE) {
            this.initUnderKitkat(url);
            StatusCallBack statusCallBack = this.statusListener;
            if (statusCallBack != null) {
                statusCallBack.onDownloadStart();
            }
            return;
        }
        new PdfDownloader(url, new PdfDownloader.StatusListener(this, pdfQuality){
            final /* synthetic */ PdfRendererView this$0;
            final /* synthetic */ PdfQuality $pdfQuality;
            {
                this.this$0 = $receiver;
                this.$pdfQuality = $pdfQuality;
            }

            @NotNull
            public Context getContext() {
                Context context = this.this$0.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                return context;
            }

            public void onDownloadStart() {
                block0: {
                    StatusCallBack statusCallBack = this.this$0.getStatusListener();
                    if (statusCallBack == null) break block0;
                    statusCallBack.onDownloadStart();
                }
            }

            public void onDownloadProgress(long currentBytes, long totalBytes) {
                block1: {
                    int progress = (int)((float)currentBytes / (float)totalBytes * 100.0f);
                    if (progress >= 100) {
                        progress = 100;
                    }
                    StatusCallBack statusCallBack = this.this$0.getStatusListener();
                    if (statusCallBack == null) break block1;
                    statusCallBack.onDownloadProgress(progress, currentBytes, totalBytes);
                }
            }

            public void onDownloadSuccess(@NotNull String absolutePath) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
                    this.this$0.initWithPath(absolutePath, this.$pdfQuality);
                    StatusCallBack statusCallBack = this.this$0.getStatusListener();
                    if (statusCallBack == null) break block0;
                    statusCallBack.onDownloadSuccess();
                }
            }

            public void onError(@NotNull Throwable error) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    error.printStackTrace();
                    StatusCallBack statusCallBack = this.this$0.getStatusListener();
                    if (statusCallBack == null) break block0;
                    statusCallBack.onError(error);
                }
            }
        });
    }

    public static /* synthetic */ void initWithUrl$default(PdfRendererView pdfRendererView, String string, PdfQuality pdfQuality, PdfEngine pdfEngine, int n, Object object) {
        if ((n & 2) != 0) {
            pdfQuality = pdfRendererView.quality;
        }
        if ((n & 4) != 0) {
            pdfEngine = pdfRendererView.engine;
        }
        pdfRendererView.initWithUrl(string, pdfQuality, pdfEngine);
    }

    public final void initWithPath(@NotNull String path, @NotNull PdfQuality pdfQuality) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)pdfQuality), (String)"pdfQuality");
        if (Build.VERSION.SDK_INT < 21) {
            throw new UnsupportedOperationException("should be over API 21");
        }
        this.initWithFile(new File(path), pdfQuality);
    }

    public static /* synthetic */ void initWithPath$default(PdfRendererView pdfRendererView, String string, PdfQuality pdfQuality, int n, Object object) {
        if ((n & 2) != 0) {
            pdfQuality = pdfRendererView.quality;
        }
        pdfRendererView.initWithPath(string, pdfQuality);
    }

    public final void initWithFile(@NotNull File file, @NotNull PdfQuality pdfQuality) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)pdfQuality), (String)"pdfQuality");
        if (Build.VERSION.SDK_INT < 21) {
            throw new UnsupportedOperationException("should be over API 21");
        }
        this.init(file, pdfQuality);
    }

    public static /* synthetic */ void initWithFile$default(PdfRendererView pdfRendererView, File file, PdfQuality pdfQuality, int n, Object object) {
        if ((n & 2) != 0) {
            pdfQuality = pdfRendererView.quality;
        }
        pdfRendererView.initWithFile(file, pdfQuality);
    }

    private final void init(File file, PdfQuality pdfQuality) {
        RecyclerView recyclerView;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        this.pdfRendererCore = new PdfRendererCore(context, file, pdfQuality);
        this.pdfRendererCoreInitialised = true;
        PdfRendererCore pdfRendererCore = this.pdfRendererCore;
        if (pdfRendererCore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdfRendererCore");
            pdfRendererCore = null;
        }
        this.pdfViewAdapter = new PdfViewAdapter(pdfRendererCore);
        View v = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.pdf_rendererview, (ViewGroup)this, false);
        this.addView(v);
        View view = this.findViewById(R.id.recyclerView);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.recyclerView)");
        this.recyclerView = (RecyclerView)view;
        RecyclerView recyclerView2 = this.recyclerView;
        if (recyclerView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerView");
            recyclerView2 = null;
        }
        RecyclerView $this$init_u24lambda_u2d4 = recyclerView = recyclerView2;
        boolean bl = false;
        PdfViewAdapter pdfViewAdapter = this.pdfViewAdapter;
        if (pdfViewAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pdfViewAdapter");
            pdfViewAdapter = null;
        }
        $this$init_u24lambda_u2d4.setAdapter((RecyclerView.Adapter)pdfViewAdapter);
        $this$init_u24lambda_u2d4.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager($this$init_u24lambda_u2d4.getContext(), 1, false));
        $this$init_u24lambda_u2d4.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        if (this.showDivider) {
            DividerItemDecoration dividerItemDecoration;
            DividerItemDecoration $this$init_u24lambda_u2d4_u24lambda_u2d2 = dividerItemDecoration = new DividerItemDecoration($this$init_u24lambda_u2d4.getContext(), 1);
            boolean bl2 = false;
            Drawable drawable = this.divider;
            if (drawable != null) {
                Drawable it = drawable;
                boolean bl3 = false;
                $this$init_u24lambda_u2d4_u24lambda_u2d2.setDrawable(it);
            }
            DividerItemDecoration it = dividerItemDecoration;
            boolean bl4 = false;
            $this$init_u24lambda_u2d4.addItemDecoration((RecyclerView.ItemDecoration)it);
        }
        $this$init_u24lambda_u2d4.addOnScrollListener((RecyclerView.OnScrollListener)this.scrollListener);
        this.runnable = () -> PdfRendererView.init$lambda-5(this);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private final void initUnderKitkat(String url) {
        View v = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.pdf_rendererview, (ViewGroup)this, false);
        this.addView(v);
        View view = this.findViewById(R.id.recyclerView);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.recyclerView)");
        this.recyclerView = (RecyclerView)view;
        RecyclerView recyclerView = this.recyclerView;
        if (recyclerView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerView");
            recyclerView = null;
        }
        recyclerView.setVisibility(8);
        ((WebView)this._$_findCachedViewById(R.id.webView)).setVisibility(0);
        ((WebView)this._$_findCachedViewById(R.id.webView)).getSettings().setJavaScriptEnabled(true);
        ((WebView)this._$_findCachedViewById(R.id.webView)).setWebViewClient((WebViewClient)new PdfWebViewClient(this.statusListener));
        ((WebView)this._$_findCachedViewById(R.id.webView)).loadUrl("https://drive.google.com/viewer/viewer?hl=en&embedded=true&url=" + URLEncoder.encode(url, "UTF-8"));
    }

    private final void getAttrs(AttributeSet attrs, int defStyle) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.PdfRendererView, defStyle, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026endererView, defStyle, 0)");
        TypedArray typedArray2 = typedArray;
        this.setTypeArray(typedArray2);
    }

    /*
     * WARNING - void declaration
     */
    private final void setTypeArray(TypedArray typedArray) {
        void element$iv;
        block5: {
            void $this$first$iv;
            void element$iv2;
            int n;
            PdfRendererView pdfRendererView;
            block4: {
                void $this$first$iv2;
                int ratio = typedArray.getInt(R.styleable.PdfRendererView_pdfView_quality, PdfQuality.NORMAL.getRatio());
                PdfQuality[] pdfQualityArray = PdfQuality.values();
                pdfRendererView = this;
                boolean $i$f$first = false;
                n = ((void)$this$first$iv2).length;
                for (int i = 0; i < n; ++i) {
                    void it = element$iv2 = $this$first$iv2[i];
                    boolean bl = false;
                    if (!(it.getRatio() == ratio)) {
                        continue;
                    }
                    break block4;
                }
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            pdfRendererView.quality = element$iv2;
            int engineValue = typedArray.getInt(R.styleable.PdfRendererView_pdfView_engine, PdfEngine.INTERNAL.getValue());
            PdfEngine[] $i$f$first = PdfEngine.values();
            pdfRendererView = this;
            boolean $i$f$first2 = false;
            int n2 = ((void)$this$first$iv).length;
            for (n = 0; n < n2; ++n) {
                void it = element$iv = $this$first$iv[n];
                boolean bl = false;
                if (!(it.getValue() == engineValue)) {
                    continue;
                }
                break block5;
            }
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        pdfRendererView.engine = element$iv;
        this.showDivider = typedArray.getBoolean(R.styleable.PdfRendererView_pdfView_showDivider, true);
        this.divider = typedArray.getDrawable(R.styleable.PdfRendererView_pdfView_divider);
        typedArray.recycle();
    }

    public final void closePdfRender() {
        if (this.pdfRendererCoreInitialised) {
            PdfRendererCore pdfRendererCore = this.pdfRendererCore;
            if (pdfRendererCore == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pdfRendererCore");
                pdfRendererCore = null;
            }
            pdfRendererCore.closePdfRender();
        }
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2 = this.findViewById(id2);
            if (view2 != null) {
                map.put(id2, view2);
                view = view2;
            } else {
                view = null;
            }
        }
        return view;
    }

    @JvmOverloads
    public PdfRendererView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public PdfRendererView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void runnable$lambda-0() {
    }

    private static final void init$lambda-5(PdfRendererView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        ((TextView)this$0._$_findCachedViewById(R.id.pageNo)).setVisibility(8);
    }

    public static final /* synthetic */ Runnable access$getRunnable$p(PdfRendererView $this) {
        return $this.runnable;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J'\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/rajat/pdfviewer/PdfRendererView$StatusCallBack;", "", "onDownloadProgress", "", "progress", "", "downloadedBytes", "", "totalBytes", "(IJLjava/lang/Long;)V", "onDownloadStart", "onDownloadSuccess", "onError", "error", "", "onPageChanged", "currentPage", "totalPage", "pdfViewer_release"})
    public static interface StatusCallBack {
        public void onDownloadStart();

        public void onDownloadProgress(int var1, long var2, @Nullable Long var4);

        public void onDownloadSuccess();

        public void onError(@NotNull Throwable var1);

        public void onPageChanged(int var1, int var2);

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void onDownloadStart(@NotNull StatusCallBack $this) {
            }

            public static void onDownloadProgress(@NotNull StatusCallBack $this, int progress, long downloadedBytes, @Nullable Long totalBytes) {
            }

            public static void onDownloadSuccess(@NotNull StatusCallBack $this) {
            }

            public static void onError(@NotNull StatusCallBack $this, @NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            }

            public static void onPageChanged(@NotNull StatusCallBack $this, int currentPage, int totalPage) {
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J&\u0010\u000b\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J.\u0010\u000b\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/rajat/pdfviewer/PdfRendererView$PdfWebViewClient;", "Landroid/webkit/WebViewClient;", "statusListener", "Lcom/rajat/pdfviewer/PdfRendererView$StatusCallBack;", "(Lcom/rajat/pdfviewer/PdfRendererView$StatusCallBack;)V", "onPageFinished", "", "view", "Landroid/webkit/WebView;", "url", "", "onReceivedError", "request", "Landroid/webkit/WebResourceRequest;", "error", "Landroid/webkit/WebResourceError;", "errorCode", "", "description", "failingUrl", "pdfViewer_release"})
    public static final class PdfWebViewClient
    extends WebViewClient {
        @Nullable
        private final StatusCallBack statusListener;

        public PdfWebViewClient(@Nullable StatusCallBack statusListener) {
            this.statusListener = statusListener;
        }

        public void onPageFinished(@Nullable WebView view, @Nullable String url) {
            block0: {
                super.onPageFinished(view, url);
                StatusCallBack statusCallBack = this.statusListener;
                if (statusCallBack == null) break block0;
                statusCallBack.onDownloadSuccess();
            }
        }

        public void onReceivedError(@Nullable WebView view, @Nullable WebResourceRequest request, @Nullable WebResourceError error) {
            block0: {
                super.onReceivedError(view, request, error);
                StatusCallBack statusCallBack = this.statusListener;
                if (statusCallBack == null) break block0;
                statusCallBack.onError(new Throwable("Web resource error"));
            }
        }

        public void onReceivedError(@Nullable WebView view, int errorCode, @Nullable String description, @Nullable String failingUrl) {
            block0: {
                super.onReceivedError(view, errorCode, description, failingUrl);
                StatusCallBack statusCallBack = this.statusListener;
                if (statusCallBack == null) break block0;
                statusCallBack.onError(new Throwable("Web resource error"));
            }
        }
    }
}

