/*
 * Decompiled with CFR 0.152.
 */
package com.rajat.pdfviewer.util;

import android.content.Context;
import android.content.res.Resources;
import android.util.Log;
import android.util.TypedValue;
import androidx.compose.runtime.internal.StabilityInferred;
import com.rajat.pdfviewer.R;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/rajat/pdfviewer/util/ThemeValidator;", "", "<init>", "()V", "hasLoggedOnce", "", "validateThemeAttributes", "", "context", "Landroid/content/Context;", "attrs", "", "", "validatePdfViewerTheme", "pdfViewer_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nThemeValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThemeValidator.kt\ncom/rajat/pdfviewer/util/ThemeValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n1869#2,2:36\n*S KotlinDebug\n*F\n+ 1 ThemeValidator.kt\ncom/rajat/pdfviewer/util/ThemeValidator\n*L\n17#1:36,2\n*E\n"})
public final class ThemeValidator {
    @NotNull
    public static final ThemeValidator INSTANCE = new ThemeValidator();
    private static boolean hasLoggedOnce;
    public static final int $stable;

    private ThemeValidator() {
    }

    public final void validateThemeAttributes(@NotNull Context context, @NotNull List<Integer> attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        if (hasLoggedOnce) {
            return;
        }
        hasLoggedOnce = true;
        Resources.Theme theme = context.getTheme();
        Iterable $this$forEach$iv = attrs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int attr2 = ((Number)element$iv).intValue();
            boolean bl = false;
            TypedValue resolved = new TypedValue();
            boolean success = theme.resolveAttribute(attr2, resolved, true);
            if (success) continue;
            Log.w((String)"PdfViewerTheme", (String)("\u26a0\ufe0f Missing theme attribute: " + context.getResources().getResourceName(attr2)));
        }
    }

    public final void validatePdfViewerTheme(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object[] objectArray = new Integer[]{0x1010031, R.attr.pdfView_toolbarColor, R.attr.pdfView_backgroundColor, R.attr.pdfView_titleTextStyle};
        this.validateThemeAttributes(context, CollectionsKt.listOf((Object[])objectArray));
    }

    static {
        $stable = 8;
    }
}

